/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicMVO;
import org.springframework.format.annotation.DateTimeFormat;

public class TrackingRecordMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    protected String href;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="characteristic")
    @Valid
    private List<CharacteristicMVO> characteristic;
    @JsonProperty(value="systemId")
    private String systemId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime time;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="uuid")
    private String uuid;

    public TrackingRecordMVO() {
    }

    public TrackingRecordMVO(String type) {
        this.type = type;
    }

    public TrackingRecordMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TrackingRecordMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public TrackingRecordMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public TrackingRecordMVO description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", example="[\"acknowledge\",\"clear\"]", description="Describes the action being done, such as: ack, clear", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TrackingRecordMVO characteristic(List<CharacteristicMVO> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public TrackingRecordMVO addCharacteristicItem(CharacteristicMVO characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<CharacteristicMVO>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Valid
    @Schema(name="characteristic", description="A generic list of any type of elements. Used for vendor Extensions or loose element encapsulation from other namespaces", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicMVO> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(List<CharacteristicMVO> characteristic) {
        this.characteristic = characteristic;
    }

    public TrackingRecordMVO systemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @Schema(name="systemId", description="Describes the system Id from which the action was done", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public TrackingRecordMVO time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Valid
    @Schema(name="time", description="Describes the time at which the action was done", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="time")
    public String getTimeString() {
        return this.time != null ? this.time.toString() : null;
    }

    public void setTime(String time) {
        if (time != null) {
            this.time = OffsetDateTime.parse(time);
        }
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public TrackingRecordMVO user(String user) {
        this.user = user;
        return this;
    }

    @Schema(name="user", description="Describes the user doing the action", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public TrackingRecordMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="Identifier of the TrackingRecord.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingRecordMVO trackingRecordMVO = (TrackingRecordMVO)o;
        return Objects.equals(this.type, trackingRecordMVO.type) && Objects.equals(this.baseType, trackingRecordMVO.baseType) && Objects.equals(this.schemaLocation, trackingRecordMVO.schemaLocation) && Objects.equals(this.description, trackingRecordMVO.description) && Objects.equals(this.characteristic, trackingRecordMVO.characteristic) && Objects.equals(this.systemId, trackingRecordMVO.systemId) && Objects.equals(this.time, trackingRecordMVO.time) && Objects.equals(this.user, trackingRecordMVO.user) && Objects.equals(this.uuid, trackingRecordMVO.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.description, this.characteristic, this.systemId, this.time, this.user, this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingRecordMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

