/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="PM628_TrackRec")
public class TrackingRecord
extends BaseRootEntity {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="characteristic")
    @Valid
    @ManyToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_track_rec_char", joinColumns={@JoinColumn(name="track_rec_uuid")}, inverseJoinColumns={@JoinColumn(name="char_uuid")})
    private List<Characteristic> characteristic = new ArrayList<Characteristic>();
    @JsonProperty(value="systemId")
    private String systemId;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime time;
    @JsonProperty(value="user")
    private String user;

    public TrackingRecord() {
    }

    public TrackingRecord(String type) {
        this.type = type;
    }

    public TrackingRecord description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", example="[\"acknowledge\",\"clear\"]", description="Describes the action being done, such as: ack, clear", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TrackingRecord characteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public TrackingRecord addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Valid
    @Schema(name="characteristic", description="A generic list of any type of elements. Used for vendor Extensions or loose element encapsulation from other namespaces", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public TrackingRecord systemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @Schema(name="systemId", description="Describes the system Id from which the action was done", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public TrackingRecord time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Valid
    @Schema(name="time", description="Describes the time at which the action was done", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="time")
    public String getTimeString() {
        return this.time != null ? this.time.toString() : null;
    }

    public void setTime(String time) {
        if (time != null) {
            this.time = OffsetDateTime.parse(time);
        }
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public TrackingRecord user(String user) {
        this.user = user;
        return this;
    }

    @Schema(name="user", description="Describes the user doing the action", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingRecord trackingRecord = (TrackingRecord)o;
        return Objects.equals(this.type, trackingRecord.type) && Objects.equals(this.baseType, trackingRecord.baseType) && Objects.equals(this.schemaLocation, trackingRecord.schemaLocation) && Objects.equals(this.description, trackingRecord.description) && Objects.equals(this.characteristic, trackingRecord.characteristic) && Objects.equals(this.systemId, trackingRecord.systemId) && Objects.equals(this.time, trackingRecord.time) && Objects.equals(this.user, trackingRecord.user) && Objects.equals(this.uuid, trackingRecord.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.description, this.characteristic, this.systemId, this.time, this.user, this.uuid);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingRecord {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

