/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.etsi.osl.tmf.pm628.model.DayOfWeekRecurrenceMVO;
import org.etsi.osl.tmf.pm628.model.MonthlyScheduleDayOfWeekDefinitionMVO;
import org.springframework.format.annotation.DateTimeFormat;

public class ScheduleDefinitionMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="uuid")
    private String uuid;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime scheduleDefinitionStartTime;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime scheduleDefinitionEndTime;
    @JsonProperty(value="recurringFrequency")
    private String recurringFrequency;
    @Valid
    private List<OffsetDateTime> excludedDate;
    @JsonProperty(value="scheduleDefinitionHourRange")
    private String scheduleDefinitionHourRange;
    @Valid
    private List<DayOfWeekRecurrenceMVO> weeklyScheduledDefinition;
    @Valid
    private List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition;
    @JsonProperty(value="MonthlyScheduleDayOfWeekDefinition")
    private MonthlyScheduleDayOfWeekDefinitionMVO monthlyScheduleDayOfWeekDefinition;
    @Valid
    private List<OffsetDateTime> dateScheduleDefintion;

    public ScheduleDefinitionMVO() {
    }

    public ScheduleDefinitionMVO(String type) {
        this.type = type;
    }

    public ScheduleDefinitionMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ScheduleDefinitionMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ScheduleDefinitionMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ScheduleDefinitionMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="Identifier of the schedule definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ScheduleDefinitionMVO scheduleDefinitionStartTime(OffsetDateTime scheduleDefinitionStartTime) {
        this.scheduleDefinitionStartTime = scheduleDefinitionStartTime;
        return this;
    }

    @Valid
    @Schema(name="scheduleDefinitionStartTime", description="The Start time of the Schedule Definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="scheduleDefinitionStartTime")
    public String getScheduleDefinitionStartTimeString() {
        return this.scheduleDefinitionStartTime != null ? this.scheduleDefinitionStartTime.toString() : null;
    }

    public void setScheduleDefinitionStartTime(String t) {
        if (t != null) {
            this.scheduleDefinitionStartTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getScheduleDefinitionStartTime() {
        return this.scheduleDefinitionStartTime;
    }

    public void setScheduleDefinitionStartTime(OffsetDateTime scheduleDefinitionStartTime) {
        this.scheduleDefinitionStartTime = scheduleDefinitionStartTime;
    }

    public ScheduleDefinitionMVO scheduleDefinitionEndTime(OffsetDateTime scheduleDefinitionEndTime) {
        this.scheduleDefinitionEndTime = scheduleDefinitionEndTime;
        return this;
    }

    @Valid
    @Schema(name="scheduleDefinitionEndTime", description="The End time of the Schedule Definition. If the attribute is empty the Schedule run forever, not having a time constraint.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="scheduleDefinitionEndTime")
    public String getScheduleDefinitionEndTimeString() {
        return this.scheduleDefinitionEndTime != null ? this.scheduleDefinitionEndTime.toString() : null;
    }

    public void setScheduleDefinitionEndTime(String t) {
        if (t != null) {
            this.scheduleDefinitionEndTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getScheduleDefinitionEndTime() {
        return this.scheduleDefinitionEndTime;
    }

    public void setScheduleDefinitionEndTime(OffsetDateTime scheduleDefinitionEndTime) {
        this.scheduleDefinitionEndTime = scheduleDefinitionEndTime;
    }

    public ScheduleDefinitionMVO recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @Schema(name="recurringFrequency", description="A recurring frequency to run a job within day that is included in schedule definition, for example: every 5 minutes, 15 minute, 30 minutes, 1 hour", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public ScheduleDefinitionMVO excludedDate(List<OffsetDateTime> excludedDate) {
        this.excludedDate = excludedDate;
        return this;
    }

    public ScheduleDefinitionMVO addExcludedDateItem(OffsetDateTime excludedDateItem) {
        if (this.excludedDate == null) {
            this.excludedDate = new ArrayList<OffsetDateTime>();
        }
        this.excludedDate.add(excludedDateItem);
        return this;
    }

    @Valid
    @Schema(name="excludedDate", description="A list of specific dates that should be excluded from the Schedule Definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="excludedDate")
    public List<String> getExcludedDateString() {
        List<String> stringList = this.excludedDate.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    @JsonProperty(value="excludedDate")
    public void setExcludedDateString(List<String> excludedDate) {
        this.excludedDate = excludedDate.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public List<OffsetDateTime> getExcludedDate() {
        return this.excludedDate;
    }

    public void setExcludedDate(List<OffsetDateTime> excludedDate) {
        this.excludedDate = excludedDate;
    }

    public ScheduleDefinitionMVO scheduleDefinitionHourRange(String scheduleDefinitionHourRange) {
        this.scheduleDefinitionHourRange = scheduleDefinitionHourRange;
        return this;
    }

    @Schema(name="scheduleDefinitionHourRange", description="A list of time ranges within a specific day that the schedule will be active on, for example 08:00-12:00, 16:00-19:00.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getScheduleDefinitionHourRange() {
        return this.scheduleDefinitionHourRange;
    }

    public void setScheduleDefinitionHourRange(String scheduleDefinitionHourRange) {
        this.scheduleDefinitionHourRange = scheduleDefinitionHourRange;
    }

    public ScheduleDefinitionMVO weeklyScheduledDefinition(List<DayOfWeekRecurrenceMVO> weeklyScheduledDefinition) {
        this.weeklyScheduledDefinition = weeklyScheduledDefinition;
        return this;
    }

    public ScheduleDefinitionMVO addWeeklyScheduledDefinitionItem(DayOfWeekRecurrenceMVO weeklyScheduledDefinitionItem) {
        if (this.weeklyScheduledDefinition == null) {
            this.weeklyScheduledDefinition = new ArrayList<DayOfWeekRecurrenceMVO>();
        }
        this.weeklyScheduledDefinition.add(weeklyScheduledDefinitionItem);
        return this;
    }

    @Valid
    @Schema(name="WeeklyScheduledDefinition", description="The weekly schedule is used to define a schedule that is based on the days of the week, e.g. a schedule that will be active only on Monday and Tuesday.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<DayOfWeekRecurrenceMVO> getWeeklyScheduledDefinition() {
        return this.weeklyScheduledDefinition;
    }

    public void setWeeklyScheduledDefinition(List<DayOfWeekRecurrenceMVO> weeklyScheduledDefinition) {
        this.weeklyScheduledDefinition = weeklyScheduledDefinition;
    }

    public ScheduleDefinitionMVO monthlyScheduleDayOfMonthDefinition(List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition;
        return this;
    }

    public ScheduleDefinitionMVO addMonthlyScheduleDayOfMonthDefinitionItem(OffsetDateTime monthlyScheduleDayOfMonthDefinitionItem) {
        if (this.monthlyScheduleDayOfMonthDefinition == null) {
            this.monthlyScheduleDayOfMonthDefinition = new ArrayList<OffsetDateTime>();
        }
        this.monthlyScheduleDayOfMonthDefinition.add(monthlyScheduleDayOfMonthDefinitionItem);
        return this;
    }

    @Valid
    @Schema(name="monthlyScheduleDayOfMonthDefinition", description="The schedule definition for running the threshold job", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="monthlyScheduleDayOfMonthDefinition")
    public List<String> getMonthlyScheduleDayOfMonthDefinitionString() {
        List<String> stringList = this.monthlyScheduleDayOfMonthDefinition.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    @JsonProperty(value="monthlyScheduleDayOfMonthDefinition")
    public void setMonthlyScheduleDayOfMonthDefinitionString(List<String> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public List<OffsetDateTime> getMonthlyScheduleDayOfMonthDefinition() {
        return this.monthlyScheduleDayOfMonthDefinition;
    }

    public void setMonthlyScheduleDayOfMonthDefinition(List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition;
    }

    public ScheduleDefinitionMVO monthlyScheduleDayOfWeekDefinition(MonthlyScheduleDayOfWeekDefinitionMVO monthlyScheduleDayOfWeekDefinition) {
        this.monthlyScheduleDayOfWeekDefinition = monthlyScheduleDayOfWeekDefinition;
        return this;
    }

    @Valid
    @Schema(name="MonthlyScheduleDayOfWeekDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonthlyScheduleDayOfWeekDefinitionMVO getMonthlyScheduleDayOfWeekDefinition() {
        return this.monthlyScheduleDayOfWeekDefinition;
    }

    public void setMonthlyScheduleDayOfWeekDefinition(MonthlyScheduleDayOfWeekDefinitionMVO monthlyScheduleDayOfWeekDefinition) {
        this.monthlyScheduleDayOfWeekDefinition = monthlyScheduleDayOfWeekDefinition;
    }

    public ScheduleDefinitionMVO dateScheduleDefintion(List<OffsetDateTime> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion;
        return this;
    }

    public ScheduleDefinitionMVO addDateScheduleDefintionItem(OffsetDateTime dateScheduleDefintionItem) {
        if (this.dateScheduleDefintion == null) {
            this.dateScheduleDefintion = new ArrayList<OffsetDateTime>();
        }
        this.dateScheduleDefintion.add(dateScheduleDefintionItem);
        return this;
    }

    @Valid
    @Schema(name="dateScheduleDefintion", description="The date schedule is used to define a schedule that is based on specific dates, such as December 31st 2015, February 28th 2013", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dateScheduleDefintion")
    public List<String> getDateScheduleDefintionString() {
        List<String> stringList = this.dateScheduleDefintion.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    @JsonProperty(value="dateScheduleDefintion")
    public void setDateScheduleDefintionString(List<String> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public List<OffsetDateTime> getDateScheduleDefintion() {
        return this.dateScheduleDefintion;
    }

    public void setDateScheduleDefintion(List<OffsetDateTime> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleDefinitionMVO scheduleDefinitionMVO = (ScheduleDefinitionMVO)o;
        return Objects.equals(this.type, scheduleDefinitionMVO.type) && Objects.equals(this.baseType, scheduleDefinitionMVO.baseType) && Objects.equals(this.schemaLocation, scheduleDefinitionMVO.schemaLocation) && Objects.equals(this.uuid, scheduleDefinitionMVO.uuid) && Objects.equals(this.scheduleDefinitionStartTime, scheduleDefinitionMVO.scheduleDefinitionStartTime) && Objects.equals(this.scheduleDefinitionEndTime, scheduleDefinitionMVO.scheduleDefinitionEndTime) && Objects.equals(this.recurringFrequency, scheduleDefinitionMVO.recurringFrequency) && Objects.equals(this.excludedDate, scheduleDefinitionMVO.excludedDate) && Objects.equals(this.scheduleDefinitionHourRange, scheduleDefinitionMVO.scheduleDefinitionHourRange) && Objects.equals(this.weeklyScheduledDefinition, scheduleDefinitionMVO.weeklyScheduledDefinition) && Objects.equals(this.monthlyScheduleDayOfMonthDefinition, scheduleDefinitionMVO.monthlyScheduleDayOfMonthDefinition) && Objects.equals(this.monthlyScheduleDayOfWeekDefinition, scheduleDefinitionMVO.monthlyScheduleDayOfWeekDefinition) && Objects.equals(this.dateScheduleDefintion, scheduleDefinitionMVO.dateScheduleDefintion);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.scheduleDefinitionStartTime, this.scheduleDefinitionEndTime, this.recurringFrequency, this.excludedDate, this.scheduleDefinitionHourRange, this.weeklyScheduledDefinition, this.monthlyScheduleDayOfMonthDefinition, this.monthlyScheduleDayOfWeekDefinition, this.dateScheduleDefintion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleDefinitionMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    scheduleDefinitionStartTime: ").append(this.toIndentedString(this.scheduleDefinitionStartTime)).append("\n");
        sb.append("    scheduleDefinitionEndTime: ").append(this.toIndentedString(this.scheduleDefinitionEndTime)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    excludedDate: ").append(this.toIndentedString(this.excludedDate)).append("\n");
        sb.append("    scheduleDefinitionHourRange: ").append(this.toIndentedString(this.scheduleDefinitionHourRange)).append("\n");
        sb.append("    weeklyScheduledDefinition: ").append(this.toIndentedString(this.weeklyScheduledDefinition)).append("\n");
        sb.append("    monthlyScheduleDayOfMonthDefinition: ").append(this.toIndentedString(this.monthlyScheduleDayOfMonthDefinition)).append("\n");
        sb.append("    monthlyScheduleDayOfWeekDefinition: ").append(this.toIndentedString(this.monthlyScheduleDayOfWeekDefinition)).append("\n");
        sb.append("    dateScheduleDefintion: ").append(this.toIndentedString(this.dateScheduleDefintion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

