/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm628.model.DayOfWeekRecurrence;
import org.etsi.osl.tmf.pm628.model.MonthlyScheduleDayOfWeekDefinition;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="PM628_SchedDef")
public class ScheduleDefinition
extends BaseRootEntity {
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime scheduleDefinitionStartTime;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime scheduleDefinitionEndTime;
    @JsonProperty(value="recurringFrequency")
    private String recurringFrequency;
    @Valid
    private List<OffsetDateTime> excludedDate = new ArrayList<OffsetDateTime>();
    @JsonProperty(value="scheduleDefinitionHourRange")
    private String scheduleDefinitionHourRange;
    @JsonProperty(value="WeeklyScheduledDefinition")
    @Valid
    @ElementCollection(targetClass=DayOfWeekRecurrence.class)
    @CollectionTable(name="pm628_sched_def_wsd", joinColumns={@JoinColumn(name="sched_def_uuid")})
    private List<DayOfWeekRecurrence> weeklyScheduledDefinition = new ArrayList<DayOfWeekRecurrence>();
    @Valid
    private List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition = new ArrayList<OffsetDateTime>();
    @JsonProperty(value="MonthlyScheduleDayOfWeekDefinition")
    @Embedded
    private MonthlyScheduleDayOfWeekDefinition monthlyScheduleDayOfWeekDefinition;
    @Valid
    private List<OffsetDateTime> dateScheduleDefintion = new ArrayList<OffsetDateTime>();

    public ScheduleDefinition() {
    }

    public ScheduleDefinition(String type) {
        this.type = type;
    }

    public ScheduleDefinition scheduleDefinitionStartTime(OffsetDateTime scheduleDefinitionStartTime) {
        this.scheduleDefinitionStartTime = scheduleDefinitionStartTime;
        return this;
    }

    @Valid
    @Schema(name="scheduleDefinitionStartTime", description="The Start time of the Schedule Definition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getScheduleDefinitionStartTime() {
        return this.scheduleDefinitionStartTime;
    }

    @JsonProperty(value="scheduleDefinitionStartTime")
    public String getScheduleDefinitionStartTimeString() {
        return this.scheduleDefinitionStartTime != null ? this.scheduleDefinitionStartTime.toString() : null;
    }

    public void setScheduleDefinitionStartTime(String t) {
        if (t != null) {
            this.scheduleDefinitionStartTime = OffsetDateTime.parse(t);
        }
    }

    public void setScheduleDefinitionStartTime(OffsetDateTime scheduleDefinitionStartTime) {
        this.scheduleDefinitionStartTime = scheduleDefinitionStartTime;
    }

    public ScheduleDefinition scheduleDefinitionEndTime(OffsetDateTime scheduleDefinitionEndTime) {
        this.scheduleDefinitionEndTime = scheduleDefinitionEndTime;
        return this;
    }

    @Valid
    @Schema(name="scheduleDefinitionEndTime", description="The End time of the Schedule Definition. If the attribute is empty the Schedule run forever, not having a time constraint.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getScheduleDefinitionEndTime() {
        return this.scheduleDefinitionEndTime;
    }

    @JsonProperty(value="scheduleDefinitionEndTime")
    public String getScheduleDefinitionEndTimeString() {
        return this.scheduleDefinitionEndTime != null ? this.scheduleDefinitionEndTime.toString() : null;
    }

    public void setScheduleDefinitionEndTime(String t) {
        if (t != null) {
            this.scheduleDefinitionEndTime = OffsetDateTime.parse(t);
        }
    }

    public void setScheduleDefinitionEndTime(OffsetDateTime scheduleDefinitionEndTime) {
        this.scheduleDefinitionEndTime = scheduleDefinitionEndTime;
    }

    public ScheduleDefinition recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @Schema(name="recurringFrequency", description="A recurring frequency to run a job within day that is included in schedule definition, for example: every 5 minutes, 15 minute, 30 minutes, 1 hour", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public ScheduleDefinition excludedDate(List<OffsetDateTime> excludedDate) {
        this.excludedDate = excludedDate;
        return this;
    }

    public ScheduleDefinition addExcludedDateItem(OffsetDateTime excludedDateItem) {
        if (this.excludedDate == null) {
            this.excludedDate = new ArrayList<OffsetDateTime>();
        }
        this.excludedDate.add(excludedDateItem);
        return this;
    }

    @Valid
    @Schema(name="excludedDate", description="A list of specific dates that should be excluded from the Schedule Definition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<OffsetDateTime> getExcludedDate() {
        return this.excludedDate;
    }

    @JsonProperty(value="excludedDate")
    public List<String> getExcludedDateString() {
        List<String> stringList = this.excludedDate.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    public void setExcludedDate(List<OffsetDateTime> excludedDate) {
        this.excludedDate = excludedDate;
    }

    @JsonProperty(value="excludedDate")
    public void setExcludedDateString(List<String> excludedDate) {
        this.excludedDate = excludedDate.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public ScheduleDefinition scheduleDefinitionHourRange(String scheduleDefinitionHourRange) {
        this.scheduleDefinitionHourRange = scheduleDefinitionHourRange;
        return this;
    }

    @Schema(name="scheduleDefinitionHourRange", description="A list of time ranges within a specific day that the schedule will be active on, for example 08:00-12:00, 16:00-19:00.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="scheduleDefinitionHourRange")
    public String getScheduleDefinitionHourRange() {
        return this.scheduleDefinitionHourRange;
    }

    public void setScheduleDefinitionHourRange(String scheduleDefinitionHourRange) {
        this.scheduleDefinitionHourRange = scheduleDefinitionHourRange;
    }

    public ScheduleDefinition weeklyScheduledDefinition(List<DayOfWeekRecurrence> weeklyScheduledDefinition) {
        this.weeklyScheduledDefinition = weeklyScheduledDefinition;
        return this;
    }

    public ScheduleDefinition addWeeklyScheduledDefinitionItem(DayOfWeekRecurrence weeklyScheduledDefinitionItem) {
        if (this.weeklyScheduledDefinition == null) {
            this.weeklyScheduledDefinition = new ArrayList<DayOfWeekRecurrence>();
        }
        this.weeklyScheduledDefinition.add(weeklyScheduledDefinitionItem);
        return this;
    }

    @Valid
    @Schema(name="WeeklyScheduledDefinition", description="The weekly schedule is used to define a schedule that is based on the days of the week, e.g. a schedule that will be active only on Monday and Tuesday.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<DayOfWeekRecurrence> getWeeklyScheduledDefinition() {
        return this.weeklyScheduledDefinition;
    }

    public void setWeeklyScheduledDefinition(List<DayOfWeekRecurrence> weeklyScheduledDefinition) {
        this.weeklyScheduledDefinition = weeklyScheduledDefinition;
    }

    public ScheduleDefinition monthlyScheduleDayOfMonthDefinition(List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition;
        return this;
    }

    public ScheduleDefinition addMonthlyScheduleDayOfMonthDefinitionItem(OffsetDateTime monthlyScheduleDayOfMonthDefinitionItem) {
        if (this.monthlyScheduleDayOfMonthDefinition == null) {
            this.monthlyScheduleDayOfMonthDefinition = new ArrayList<OffsetDateTime>();
        }
        this.monthlyScheduleDayOfMonthDefinition.add(monthlyScheduleDayOfMonthDefinitionItem);
        return this;
    }

    @Valid
    @Schema(name="monthlyScheduleDayOfMonthDefinition", description="The schedule definition for running the threshold job", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<OffsetDateTime> getMonthlyScheduleDayOfMonthDefinition() {
        return this.monthlyScheduleDayOfMonthDefinition;
    }

    @JsonProperty(value="monthlyScheduleDayOfMonthDefinition")
    public List<String> getMonthlyScheduleDayOfMonthDefinitionString() {
        List<String> stringList = this.monthlyScheduleDayOfMonthDefinition.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    public void setMonthlyScheduleDayOfMonthDefinition(List<OffsetDateTime> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition;
    }

    @JsonProperty(value="monthlyScheduleDayOfMonthDefinition")
    public void setMonthlyScheduleDayOfMonthDefinitionString(List<String> monthlyScheduleDayOfMonthDefinition) {
        this.monthlyScheduleDayOfMonthDefinition = monthlyScheduleDayOfMonthDefinition.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    public ScheduleDefinition monthlyScheduleDayOfWeekDefinition(MonthlyScheduleDayOfWeekDefinition monthlyScheduleDayOfWeekDefinition) {
        this.monthlyScheduleDayOfWeekDefinition = monthlyScheduleDayOfWeekDefinition;
        return this;
    }

    @Valid
    @Schema(name="MonthlyScheduleDayOfWeekDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonthlyScheduleDayOfWeekDefinition getMonthlyScheduleDayOfWeekDefinition() {
        return this.monthlyScheduleDayOfWeekDefinition;
    }

    public void setMonthlyScheduleDayOfWeekDefinition(MonthlyScheduleDayOfWeekDefinition monthlyScheduleDayOfWeekDefinition) {
        this.monthlyScheduleDayOfWeekDefinition = monthlyScheduleDayOfWeekDefinition;
    }

    public ScheduleDefinition dateScheduleDefintion(List<OffsetDateTime> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion;
        return this;
    }

    public ScheduleDefinition addDateScheduleDefintionItem(OffsetDateTime dateScheduleDefintionItem) {
        if (this.dateScheduleDefintion == null) {
            this.dateScheduleDefintion = new ArrayList<OffsetDateTime>();
        }
        this.dateScheduleDefintion.add(dateScheduleDefintionItem);
        return this;
    }

    @Valid
    @Schema(name="dateScheduleDefintion", description="The date schedule is used to define a schedule that is based on specific dates, such as December 31st 2015, February 28th 2013", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<OffsetDateTime> getDateScheduleDefintion() {
        return this.dateScheduleDefintion;
    }

    @JsonProperty(value="dateScheduleDefintion")
    public List<String> getDateScheduleDefintionString() {
        List<String> stringList = this.dateScheduleDefintion.stream().map(OffsetDateTime::toString).collect(Collectors.toList());
        return stringList;
    }

    public void setDateScheduleDefintion(List<OffsetDateTime> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion;
    }

    @JsonProperty(value="dateScheduleDefintion")
    public void setDateScheduleDefintionString(List<String> dateScheduleDefintion) {
        this.dateScheduleDefintion = dateScheduleDefintion.stream().map(date -> {
            try {
                return OffsetDateTime.parse(date);
            }
            catch (DateTimeParseException e) {
                System.err.println("Invalid date format: " + date);
                return null;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleDefinition scheduleDefinition = (ScheduleDefinition)o;
        return Objects.equals(this.type, scheduleDefinition.type) && Objects.equals(this.baseType, scheduleDefinition.baseType) && Objects.equals(this.schemaLocation, scheduleDefinition.schemaLocation) && Objects.equals(this.uuid, scheduleDefinition.uuid) && Objects.equals(this.scheduleDefinitionStartTime, scheduleDefinition.scheduleDefinitionStartTime) && Objects.equals(this.scheduleDefinitionEndTime, scheduleDefinition.scheduleDefinitionEndTime) && Objects.equals(this.recurringFrequency, scheduleDefinition.recurringFrequency) && Objects.equals(this.excludedDate, scheduleDefinition.excludedDate) && Objects.equals(this.scheduleDefinitionHourRange, scheduleDefinition.scheduleDefinitionHourRange) && Objects.equals(this.weeklyScheduledDefinition, scheduleDefinition.weeklyScheduledDefinition) && Objects.equals(this.monthlyScheduleDayOfMonthDefinition, scheduleDefinition.monthlyScheduleDayOfMonthDefinition) && Objects.equals(this.monthlyScheduleDayOfWeekDefinition, scheduleDefinition.monthlyScheduleDayOfWeekDefinition) && Objects.equals(this.dateScheduleDefintion, scheduleDefinition.dateScheduleDefintion);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.scheduleDefinitionStartTime, this.scheduleDefinitionEndTime, this.recurringFrequency, this.excludedDate, this.scheduleDefinitionHourRange, this.weeklyScheduledDefinition, this.monthlyScheduleDayOfMonthDefinition, this.monthlyScheduleDayOfWeekDefinition, this.dateScheduleDefintion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleDefinition {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    scheduleDefinitionStartTime: ").append(this.toIndentedString(this.scheduleDefinitionStartTime)).append("\n");
        sb.append("    scheduleDefinitionEndTime: ").append(this.toIndentedString(this.scheduleDefinitionEndTime)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    excludedDate: ").append(this.toIndentedString(this.excludedDate)).append("\n");
        sb.append("    scheduleDefinitionHourRange: ").append(this.toIndentedString(this.scheduleDefinitionHourRange)).append("\n");
        sb.append("    weeklyScheduledDefinition: ").append(this.toIndentedString(this.weeklyScheduledDefinition)).append("\n");
        sb.append("    monthlyScheduleDayOfMonthDefinition: ").append(this.toIndentedString(this.monthlyScheduleDayOfMonthDefinition)).append("\n");
        sb.append("    monthlyScheduleDayOfWeekDefinition: ").append(this.toIndentedString(this.monthlyScheduleDayOfWeekDefinition)).append("\n");
        sb.append("    dateScheduleDefintion: ").append(this.toIndentedString(this.dateScheduleDefintion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

