/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicMVO;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValueMVO;

public class ResourceRelationshipMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="resourceRelationshipCharacteristic")
    @Valid
    private List<CharacteristicMVO> resourceRelationshipCharacteristic;
    @JsonProperty(value="resource")
    private ResourceRefOrValueMVO resource;
    @JsonProperty(value="relationshipType")
    private String relationshipType;

    public ResourceRelationshipMVO() {
    }

    public ResourceRelationshipMVO(String type, ResourceRefOrValueMVO resource, String relationshipType) {
        this.type = type;
        this.resource = resource;
        this.relationshipType = relationshipType;
    }

    public ResourceRelationshipMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceRelationshipMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceRelationshipMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceRelationshipMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="Unique identifier of the characteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ResourceRelationshipMVO resourceRelationshipCharacteristic(List<CharacteristicMVO> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
        return this;
    }

    public ResourceRelationshipMVO addResourceRelationshipCharacteristicItem(CharacteristicMVO resourceRelationshipCharacteristicItem) {
        if (this.resourceRelationshipCharacteristic == null) {
            this.resourceRelationshipCharacteristic = new ArrayList<CharacteristicMVO>();
        }
        this.resourceRelationshipCharacteristic.add(resourceRelationshipCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationshipCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicMVO> getResourceRelationshipCharacteristic() {
        return this.resourceRelationshipCharacteristic;
    }

    public void setResourceRelationshipCharacteristic(List<CharacteristicMVO> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
    }

    public ResourceRelationshipMVO resource(ResourceRefOrValueMVO resource) {
        this.resource = resource;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="resource", requiredMode=Schema.RequiredMode.REQUIRED)
    public ResourceRefOrValueMVO getResource() {
        return this.resource;
    }

    public void setResource(ResourceRefOrValueMVO resource) {
        this.resource = resource;
    }

    public ResourceRelationshipMVO relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @NotNull
    @Schema(name="relationshipType", description="Type of the resource relationship, such as [bundled] if the resource is a bundle and you want to describe the bundled resources inside this bundle; [reliesOn] if the resource needs another already owned resource to rely on (eg: an option on an already owned mobile access resource) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRelationshipMVO resourceRelationshipMVO = (ResourceRelationshipMVO)o;
        return Objects.equals(this.type, resourceRelationshipMVO.type) && Objects.equals(this.baseType, resourceRelationshipMVO.baseType) && Objects.equals(this.schemaLocation, resourceRelationshipMVO.schemaLocation) && Objects.equals(this.uuid, resourceRelationshipMVO.uuid) && Objects.equals(this.resourceRelationshipCharacteristic, resourceRelationshipMVO.resourceRelationshipCharacteristic) && Objects.equals(this.resource, resourceRelationshipMVO.resource) && Objects.equals(this.relationshipType, resourceRelationshipMVO.relationshipType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.resourceRelationshipCharacteristic, this.resource, this.relationshipType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceRelationshipMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    resourceRelationshipCharacteristic: ").append(this.toIndentedString(this.resourceRelationshipCharacteristic)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

