/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicFVO;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValueFVO;

public class ResourceRelationshipFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="resourceRelationshipCharacteristic")
    @Valid
    private List<CharacteristicFVO> resourceRelationshipCharacteristic = new ArrayList<CharacteristicFVO>();
    @JsonProperty(value="resource")
    private ResourceRefOrValueFVO resource;
    @JsonProperty(value="relationshipType")
    private String relationshipType;

    public ResourceRelationshipFVO() {
    }

    public ResourceRelationshipFVO(String type, ResourceRefOrValueFVO resource, String relationshipType) {
        this.type = type;
        this.resource = resource;
        this.relationshipType = relationshipType;
    }

    public ResourceRelationshipFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceRelationshipFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceRelationshipFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceRelationshipFVO resourceRelationshipCharacteristic(List<CharacteristicFVO> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
        return this;
    }

    public ResourceRelationshipFVO addResourceRelationshipCharacteristicItem(CharacteristicFVO resourceRelationshipCharacteristicItem) {
        if (this.resourceRelationshipCharacteristic == null) {
            this.resourceRelationshipCharacteristic = new ArrayList<CharacteristicFVO>();
        }
        this.resourceRelationshipCharacteristic.add(resourceRelationshipCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationshipCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicFVO> getResourceRelationshipCharacteristic() {
        return this.resourceRelationshipCharacteristic;
    }

    public void setResourceRelationshipCharacteristic(List<CharacteristicFVO> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
    }

    public ResourceRelationshipFVO resource(ResourceRefOrValueFVO resource) {
        this.resource = resource;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="resource", requiredMode=Schema.RequiredMode.REQUIRED)
    public ResourceRefOrValueFVO getResource() {
        return this.resource;
    }

    public void setResource(ResourceRefOrValueFVO resource) {
        this.resource = resource;
    }

    public ResourceRelationshipFVO relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @NotNull
    @Schema(name="relationshipType", description="Type of the resource relationship, such as [bundled] if the resource is a bundle and you want to describe the bundled resources inside this bundle; [reliesOn] if the resource needs another already owned resource to rely on (eg: an option on an already owned mobile access resource) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRelationshipFVO resourceRelationshipFVO = (ResourceRelationshipFVO)o;
        return Objects.equals(this.type, resourceRelationshipFVO.type) && Objects.equals(this.baseType, resourceRelationshipFVO.baseType) && Objects.equals(this.schemaLocation, resourceRelationshipFVO.schemaLocation) && Objects.equals(this.resourceRelationshipCharacteristic, resourceRelationshipFVO.resourceRelationshipCharacteristic) && Objects.equals(this.resource, resourceRelationshipFVO.resource) && Objects.equals(this.relationshipType, resourceRelationshipFVO.relationshipType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.resourceRelationshipCharacteristic, this.resource, this.relationshipType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceRelationshipFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    resourceRelationshipCharacteristic: ").append(this.toIndentedString(this.resourceRelationshipCharacteristic)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

