/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.LogicalResource;
import org.etsi.osl.tmf.pm628.model.Resource;
import org.etsi.osl.tmf.pm628.model.ResourceRef;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValue;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;

@Entity(name="PM628_ResourceRel")
public class ResourceRelationship
extends BaseRootEntity {
    @JsonProperty(value="resourceRelationshipCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_rel_res_rel_char", joinColumns={@JoinColumn(name="resource_rel_uuid")}, inverseJoinColumns={@JoinColumn(name="res_rel_char_uuid")})
    private List<Characteristic> resourceRelationshipCharacteristic = new ArrayList<Characteristic>();
    @JsonProperty(value="resource")
    @Any
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="dae", entity=DataAccessEndpoint.class), @AnyDiscriminatorValue(discriminator="lr", entity=LogicalResource.class), @AnyDiscriminatorValue(discriminator="r", entity=Resource.class), @AnyDiscriminatorValue(discriminator="rr", entity=ResourceRef.class)})
    @AnyKeyJavaClass(value=String.class)
    @Column(name="resource_type")
    @JoinColumn(name="resource_id")
    private ResourceRefOrValue resource;
    @JsonProperty(value="relationshipType")
    private String relationshipType;

    public ResourceRelationship() {
    }

    public ResourceRelationship(String type) {
        this.type = type;
    }

    public ResourceRelationship type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public ResourceRelationship baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public ResourceRelationship schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceRelationship resourceRelationshipCharacteristic(List<Characteristic> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
        return this;
    }

    public ResourceRelationship addResourceRelationshipCharacteristicItem(Characteristic resourceRelationshipCharacteristicItem) {
        if (this.resourceRelationshipCharacteristic == null) {
            this.resourceRelationshipCharacteristic = new ArrayList<Characteristic>();
        }
        this.resourceRelationshipCharacteristic.add(resourceRelationshipCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationshipCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Characteristic> getResourceRelationshipCharacteristic() {
        return this.resourceRelationshipCharacteristic;
    }

    public void setResourceRelationshipCharacteristic(List<Characteristic> resourceRelationshipCharacteristic) {
        this.resourceRelationshipCharacteristic = resourceRelationshipCharacteristic;
    }

    public ResourceRelationship resource(ResourceRefOrValue resource) {
        this.resource = resource;
        return this;
    }

    @Valid
    @Schema(name="resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceRefOrValue getResource() {
        return this.resource;
    }

    public void setResource(ResourceRefOrValue resource) {
        this.resource = resource;
    }

    public ResourceRelationship relationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Schema(name="relationshipType", description="Type of the resource relationship, such as [bundled] if the resource is a bundle and you want to describe the bundled resources inside this bundle; [reliesOn] if the resource needs another already owned resource to rely on (eg: an option on an already owned mobile access resource) [targets] or [isTargeted] (depending on the way of expressing the link) for any other kind of links that may be useful", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRelationship resourceRelationship = (ResourceRelationship)o;
        return Objects.equals(this.type, resourceRelationship.type) && Objects.equals(this.baseType, resourceRelationship.baseType) && Objects.equals(this.schemaLocation, resourceRelationship.schemaLocation) && Objects.equals(this.uuid, resourceRelationship.uuid) && Objects.equals(this.resourceRelationshipCharacteristic, resourceRelationship.resourceRelationshipCharacteristic) && Objects.equals(this.resource, resourceRelationship.resource) && Objects.equals(this.relationshipType, resourceRelationship.relationshipType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.uuid, this.resourceRelationshipCharacteristic, this.resource, this.relationshipType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceRelationship {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    resourceRelationshipCharacteristic: ").append(this.toIndentedString(this.resourceRelationshipCharacteristic)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString(this.relationshipType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

