/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValue;

@Schema(name="ResourceRef", description="Resource reference, for when Resource is used by other entities.")
@Entity(name="PM628_ResourceRef")
public class ResourceRef
extends BaseRootNamedEntity
implements ResourceRefOrValue {
    @JsonProperty(value="@referredType")
    private String referredType;

    public ResourceRef() {
    }

    public ResourceRef(String type, String uuid) {
        this.type = type;
        this.uuid = uuid;
    }

    public ResourceRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRef resourceRef = (ResourceRef)o;
        return Objects.equals(this.type, resourceRef.type) && Objects.equals(this.baseType, resourceRef.baseType) && Objects.equals(this.schemaLocation, resourceRef.schemaLocation) && Objects.equals(this.href, resourceRef.href) && Objects.equals(this.uuid, resourceRef.uuid) && Objects.equals(this.name, resourceRef.name) && Objects.equals(this.referredType, resourceRef.referredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceRef {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

