/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.AttachmentRefMVO;
import org.etsi.osl.tmf.pm628.model.CharacteristicMVO;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointMVO;
import org.etsi.osl.tmf.pm628.model.ExternalIdentifierMVO;
import org.etsi.osl.tmf.pm628.model.FeatureMVO;
import org.etsi.osl.tmf.pm628.model.IntentRefMVO;
import org.etsi.osl.tmf.pm628.model.LogicalResourceMVO;
import org.etsi.osl.tmf.pm628.model.NoteMVO;
import org.etsi.osl.tmf.pm628.model.RelatedPartyRefOrPartyRoleRefMVO;
import org.etsi.osl.tmf.pm628.model.RelatedPlaceRefMVO;
import org.etsi.osl.tmf.pm628.model.RelatedResourceOrderItemMVO;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValueMVO;
import org.etsi.osl.tmf.pm628.model.ResourceRelationshipMVO;
import org.etsi.osl.tmf.pm628.model.ResourceSpecificationRefMVO;
import org.etsi.osl.tmf.pm628.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAccessEndpointMVO.class, name="DataAccessEndpoint"), @JsonSubTypes.Type(value=LogicalResourceMVO.class, name="LogicalResource"), @JsonSubTypes.Type(value=ResourceMVO.class, name="Resource")})
public class ResourceMVO
implements ResourceRefOrValueMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime endOperatingDate;
    @JsonProperty(value="administrativeState")
    private ResourceAdministrativeStateType administrativeState;
    @JsonProperty(value="operationalState")
    private ResourceOperationalStateType operationalState;
    @JsonProperty(value="resourceStatus")
    private ResourceStatusType resourceStatus;
    @JsonProperty(value="usageState")
    private ResourceUsageStateType usageState;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;
    @JsonProperty(value="note")
    @Valid
    private List<NoteMVO> note;
    @JsonProperty(value="resourceOrderItem")
    @Valid
    private List<RelatedResourceOrderItemMVO> resourceOrderItem;
    @JsonProperty(value="place")
    @Valid
    private List<RelatedPlaceRefMVO> place;
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty;
    @JsonProperty(value="resourceRelationship")
    @Valid
    private List<ResourceRelationshipMVO> resourceRelationship;
    @JsonProperty(value="resourceCharacteristic")
    @Valid
    private List<CharacteristicMVO> resourceCharacteristic;
    @JsonProperty(value="attachment")
    @Valid
    private List<AttachmentRefMVO> attachment;
    @JsonProperty(value="resourceSpecification")
    private ResourceSpecificationRefMVO resourceSpecification;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startOperatingDate;
    @JsonProperty(value="resourceVersion")
    private String resourceVersion;
    @JsonProperty(value="activationFeature")
    @Valid
    private List<FeatureMVO> activationFeature;
    @JsonProperty(value="intent")
    private IntentRefMVO intent;
    @JsonProperty(value="externalIdentifier")
    @Valid
    private List<ExternalIdentifierMVO> externalIdentifier;

    public ResourceMVO() {
    }

    public ResourceMVO(String type) {
        this.type = type;
    }

    public ResourceMVO type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public ResourceMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceMVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ResourceMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ResourceMVO category(String category) {
        this.category = category;
        return this;
    }

    @Schema(name="category", description="Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceMVO description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="free-text description of the resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceMVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="the name of the resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceMVO endOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="endOperatingDate", description="A date time( DateTime). The date till the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="endOperatingDate")
    public String getEndOperatingDateString() {
        return this.endOperatingDate != null ? this.endOperatingDate.toString() : null;
    }

    public void setEndOperatingDate(String endOperatingDate) {
        if (endOperatingDate != null) {
            this.endOperatingDate = OffsetDateTime.parse(endOperatingDate);
        }
    }

    public OffsetDateTime getEndOperatingDate() {
        return this.endOperatingDate;
    }

    public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
    }

    public ResourceMVO administrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
        return this;
    }

    @Valid
    @Schema(name="administrativeState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceAdministrativeStateType getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
    }

    public ResourceMVO operationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
        return this;
    }

    @Valid
    @Schema(name="operationalState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceOperationalStateType getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
    }

    public ResourceMVO resourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
        return this;
    }

    @Valid
    @Schema(name="resourceStatus", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceStatusType getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public ResourceMVO usageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
        return this;
    }

    @Valid
    @Schema(name="usageState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceUsageStateType getUsageState() {
        return this.usageState;
    }

    public void setUsageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
    }

    public ResourceMVO validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceMVO note(List<NoteMVO> note) {
        this.note = note;
        return this;
    }

    public ResourceMVO addNoteItem(NoteMVO noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<NoteMVO>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Valid
    @Schema(name="note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<NoteMVO> getNote() {
        return this.note;
    }

    public void setNote(List<NoteMVO> note) {
        this.note = note;
    }

    public ResourceMVO resourceOrderItem(List<RelatedResourceOrderItemMVO> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
        return this;
    }

    public ResourceMVO addResourceOrderItemItem(RelatedResourceOrderItemMVO resourceOrderItemItem) {
        if (this.resourceOrderItem == null) {
            this.resourceOrderItem = new ArrayList<RelatedResourceOrderItemMVO>();
        }
        this.resourceOrderItem.add(resourceOrderItemItem);
        return this;
    }

    @Valid
    @Schema(name="resourceOrderItem", description="A list of resource order items related to this resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedResourceOrderItemMVO> getResourceOrderItem() {
        return this.resourceOrderItem;
    }

    public void setResourceOrderItem(List<RelatedResourceOrderItemMVO> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
    }

    public ResourceMVO place(List<RelatedPlaceRefMVO> place) {
        this.place = place;
        return this;
    }

    public ResourceMVO addPlaceItem(RelatedPlaceRefMVO placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<RelatedPlaceRefMVO>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPlaceRefMVO> getPlace() {
        return this.place;
    }

    public void setPlace(List<RelatedPlaceRefMVO> place) {
        this.place = place;
    }

    public ResourceMVO relatedParty(List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceMVO addRelatedPartyItem(RelatedPartyRefOrPartyRoleRefMVO relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRefMVO>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPartyRefOrPartyRoleRefMVO> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRefMVO> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceMVO resourceRelationship(List<ResourceRelationshipMVO> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this;
    }

    public ResourceMVO addResourceRelationshipItem(ResourceRelationshipMVO resourceRelationshipItem) {
        if (this.resourceRelationship == null) {
            this.resourceRelationship = new ArrayList<ResourceRelationshipMVO>();
        }
        this.resourceRelationship.add(resourceRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ResourceRelationshipMVO> getResourceRelationship() {
        return this.resourceRelationship;
    }

    public void setResourceRelationship(List<ResourceRelationshipMVO> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
    }

    public ResourceMVO resourceCharacteristic(List<CharacteristicMVO> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
        return this;
    }

    public ResourceMVO addResourceCharacteristicItem(CharacteristicMVO resourceCharacteristicItem) {
        if (this.resourceCharacteristic == null) {
            this.resourceCharacteristic = new ArrayList<CharacteristicMVO>();
        }
        this.resourceCharacteristic.add(resourceCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicMVO> getResourceCharacteristic() {
        return this.resourceCharacteristic;
    }

    public void setResourceCharacteristic(List<CharacteristicMVO> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
    }

    public ResourceMVO attachment(List<AttachmentRefMVO> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ResourceMVO addAttachmentItem(AttachmentRefMVO attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefMVO>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Valid
    @Schema(name="attachment", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<AttachmentRefMVO> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefMVO> attachment) {
        this.attachment = attachment;
    }

    public ResourceMVO resourceSpecification(ResourceSpecificationRefMVO resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Valid
    @Schema(name="resourceSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceSpecificationRefMVO getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRefMVO resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ResourceMVO startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="startOperatingDate", description="A date time( DateTime). The date from which the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startOperatingDate")
    public String getStartOperatingDateString() {
        return this.startOperatingDate != null ? this.startOperatingDate.toString() : null;
    }

    public void setStartOperatingDate(String startOperatingDate) {
        if (startOperatingDate != null) {
            this.startOperatingDate = OffsetDateTime.parse(startOperatingDate);
        }
    }

    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public ResourceMVO resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Schema(name="resourceVersion", description="A field that identifies the specific version of an instance of a resource.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public ResourceMVO activationFeature(List<FeatureMVO> activationFeature) {
        this.activationFeature = activationFeature;
        return this;
    }

    public ResourceMVO addActivationFeatureItem(FeatureMVO activationFeatureItem) {
        if (this.activationFeature == null) {
            this.activationFeature = new ArrayList<FeatureMVO>();
        }
        this.activationFeature.add(activationFeatureItem);
        return this;
    }

    @Valid
    @Schema(name="activationFeature", description="Configuration features", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<FeatureMVO> getActivationFeature() {
        return this.activationFeature;
    }

    public void setActivationFeature(List<FeatureMVO> activationFeature) {
        this.activationFeature = activationFeature;
    }

    public ResourceMVO intent(IntentRefMVO intent) {
        this.intent = intent;
        return this;
    }

    @Valid
    @Schema(name="intent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public IntentRefMVO getIntent() {
        return this.intent;
    }

    public void setIntent(IntentRefMVO intent) {
        this.intent = intent;
    }

    public ResourceMVO externalIdentifier(List<ExternalIdentifierMVO> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    public ResourceMVO addExternalIdentifierItem(ExternalIdentifierMVO externalIdentifierItem) {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifierMVO>();
        }
        this.externalIdentifier.add(externalIdentifierItem);
        return this;
    }

    @Valid
    @Schema(name="externalIdentifier", description="An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ExternalIdentifierMVO> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(List<ExternalIdentifierMVO> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceMVO resourceMVO = (ResourceMVO)o;
        return Objects.equals(this.type, resourceMVO.type) && Objects.equals(this.baseType, resourceMVO.baseType) && Objects.equals(this.schemaLocation, resourceMVO.schemaLocation) && Objects.equals(this.href, resourceMVO.href) && Objects.equals(this.uuid, resourceMVO.uuid) && Objects.equals(this.category, resourceMVO.category) && Objects.equals(this.description, resourceMVO.description) && Objects.equals(this.name, resourceMVO.name) && Objects.equals(this.endOperatingDate, resourceMVO.endOperatingDate) && Objects.equals((Object)this.administrativeState, (Object)resourceMVO.administrativeState) && Objects.equals((Object)this.operationalState, (Object)resourceMVO.operationalState) && Objects.equals((Object)this.resourceStatus, (Object)resourceMVO.resourceStatus) && Objects.equals((Object)this.usageState, (Object)resourceMVO.usageState) && Objects.equals(this.validFor, resourceMVO.validFor) && Objects.equals(this.note, resourceMVO.note) && Objects.equals(this.resourceOrderItem, resourceMVO.resourceOrderItem) && Objects.equals(this.place, resourceMVO.place) && Objects.equals(this.relatedParty, resourceMVO.relatedParty) && Objects.equals(this.resourceRelationship, resourceMVO.resourceRelationship) && Objects.equals(this.resourceCharacteristic, resourceMVO.resourceCharacteristic) && Objects.equals(this.attachment, resourceMVO.attachment) && Objects.equals(this.resourceSpecification, resourceMVO.resourceSpecification) && Objects.equals(this.startOperatingDate, resourceMVO.startOperatingDate) && Objects.equals(this.resourceVersion, resourceMVO.resourceVersion) && Objects.equals(this.activationFeature, resourceMVO.activationFeature) && Objects.equals(this.intent, resourceMVO.intent) && Objects.equals(this.externalIdentifier, resourceMVO.externalIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.category, this.description, this.name, this.endOperatingDate, this.administrativeState, this.operationalState, this.resourceStatus, this.usageState, this.validFor, this.note, this.resourceOrderItem, this.place, this.relatedParty, this.resourceRelationship, this.resourceCharacteristic, this.attachment, this.resourceSpecification, this.startOperatingDate, this.resourceVersion, this.activationFeature, this.intent, this.externalIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceMVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    resourceOrderItem: ").append(this.toIndentedString(this.resourceOrderItem)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

