/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.AttachmentRefFVO;
import org.etsi.osl.tmf.pm628.model.CharacteristicFVO;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointFVO;
import org.etsi.osl.tmf.pm628.model.ExternalIdentifierFVO;
import org.etsi.osl.tmf.pm628.model.FeatureFVO;
import org.etsi.osl.tmf.pm628.model.IntentRefFVO;
import org.etsi.osl.tmf.pm628.model.LogicalResourceFVO;
import org.etsi.osl.tmf.pm628.model.NoteFVO;
import org.etsi.osl.tmf.pm628.model.RelatedPartyRefOrPartyRoleRefFVO;
import org.etsi.osl.tmf.pm628.model.RelatedPlaceRefFVO;
import org.etsi.osl.tmf.pm628.model.RelatedResourceOrderItemFVO;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValueFVO;
import org.etsi.osl.tmf.pm628.model.ResourceRelationshipFVO;
import org.etsi.osl.tmf.pm628.model.ResourceSpecificationRefFVO;
import org.etsi.osl.tmf.pm628.model.ResourceStatusType;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAccessEndpointFVO.class, name="DataAccessEndpoint"), @JsonSubTypes.Type(value=LogicalResourceFVO.class, name="LogicalResource"), @JsonSubTypes.Type(value=ResourceFVO.class, name="Resource")})
public class ResourceFVO
implements ResourceRefOrValueFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime endOperatingDate;
    @JsonProperty(value="administrativeState")
    private ResourceAdministrativeStateType administrativeState;
    @JsonProperty(value="operationalState")
    private ResourceOperationalStateType operationalState;
    @JsonProperty(value="resourceStatus")
    private ResourceStatusType resourceStatus;
    @JsonProperty(value="usageState")
    private ResourceUsageStateType usageState;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;
    @JsonProperty(value="note")
    @Valid
    private List<NoteFVO> note = new ArrayList<NoteFVO>();
    @JsonProperty(value="resourceOrderItem")
    @Valid
    private List<RelatedResourceOrderItemFVO> resourceOrderItem = new ArrayList<RelatedResourceOrderItemFVO>();
    @JsonProperty(value="place")
    @Valid
    private List<RelatedPlaceRefFVO> place = new ArrayList<RelatedPlaceRefFVO>();
    @JsonProperty(value="relatedParty")
    @Valid
    private List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRefFVO>();
    @JsonProperty(value="resourceRelationship")
    @Valid
    private List<ResourceRelationshipFVO> resourceRelationship = new ArrayList<ResourceRelationshipFVO>();
    @JsonProperty(value="resourceCharacteristic")
    @Valid
    private List<CharacteristicFVO> resourceCharacteristic = new ArrayList<CharacteristicFVO>();
    @JsonProperty(value="attachment")
    @Valid
    private List<AttachmentRefFVO> attachment = new ArrayList<AttachmentRefFVO>();
    @JsonProperty(value="resourceSpecification")
    private ResourceSpecificationRefFVO resourceSpecification;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startOperatingDate;
    @JsonProperty(value="resourceVersion")
    private String resourceVersion;
    @JsonProperty(value="activationFeature")
    @Valid
    private List<FeatureFVO> activationFeature = new ArrayList<FeatureFVO>();
    @JsonProperty(value="intent")
    private IntentRefFVO intent;
    @JsonProperty(value="externalIdentifier")
    @Valid
    private List<ExternalIdentifierFVO> externalIdentifier = new ArrayList<ExternalIdentifierFVO>();

    public ResourceFVO() {
    }

    public ResourceFVO(String type) {
        this.type = type;
    }

    public ResourceFVO type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ResourceFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ResourceFVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ResourceFVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ResourceFVO category(String category) {
        this.category = category;
        return this;
    }

    @Schema(name="category", description="Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public ResourceFVO description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="free-text description of the resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceFVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="the name of the resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceFVO endOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="endOperatingDate", description="A date time( DateTime). The date till the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="endOperatingDate")
    public String getEndOperatingDateString() {
        return this.endOperatingDate != null ? this.endOperatingDate.toString() : null;
    }

    public void setEndOperatingDate(String endOperatingDate) {
        if (endOperatingDate != null) {
            this.endOperatingDate = OffsetDateTime.parse(endOperatingDate);
        }
    }

    public OffsetDateTime getEndOperatingDate() {
        return this.endOperatingDate;
    }

    public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
    }

    public ResourceFVO administrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
        return this;
    }

    @Valid
    @Schema(name="administrativeState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceAdministrativeStateType getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
    }

    public ResourceFVO operationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
        return this;
    }

    @Valid
    @Schema(name="operationalState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceOperationalStateType getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
    }

    public ResourceFVO resourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
        return this;
    }

    @Valid
    @Schema(name="resourceStatus", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceStatusType getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public ResourceFVO usageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
        return this;
    }

    @Valid
    @Schema(name="usageState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceUsageStateType getUsageState() {
        return this.usageState;
    }

    public void setUsageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
    }

    public ResourceFVO validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ResourceFVO note(List<NoteFVO> note) {
        this.note = note;
        return this;
    }

    public ResourceFVO addNoteItem(NoteFVO noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<NoteFVO>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Valid
    @Schema(name="note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<NoteFVO> getNote() {
        return this.note;
    }

    public void setNote(List<NoteFVO> note) {
        this.note = note;
    }

    public ResourceFVO resourceOrderItem(List<RelatedResourceOrderItemFVO> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
        return this;
    }

    public ResourceFVO addResourceOrderItemItem(RelatedResourceOrderItemFVO resourceOrderItemItem) {
        if (this.resourceOrderItem == null) {
            this.resourceOrderItem = new ArrayList<RelatedResourceOrderItemFVO>();
        }
        this.resourceOrderItem.add(resourceOrderItemItem);
        return this;
    }

    @Valid
    @Schema(name="resourceOrderItem", description="A list of resource order items related to this resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedResourceOrderItemFVO> getResourceOrderItem() {
        return this.resourceOrderItem;
    }

    public void setResourceOrderItem(List<RelatedResourceOrderItemFVO> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
    }

    public ResourceFVO place(List<RelatedPlaceRefFVO> place) {
        this.place = place;
        return this;
    }

    public ResourceFVO addPlaceItem(RelatedPlaceRefFVO placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<RelatedPlaceRefFVO>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPlaceRefFVO> getPlace() {
        return this.place;
    }

    public void setPlace(List<RelatedPlaceRefFVO> place) {
        this.place = place;
    }

    public ResourceFVO relatedParty(List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ResourceFVO addRelatedPartyItem(RelatedPartyRefOrPartyRoleRefFVO relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRefFVO>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPartyRefOrPartyRoleRefFVO> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRefFVO> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ResourceFVO resourceRelationship(List<ResourceRelationshipFVO> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this;
    }

    public ResourceFVO addResourceRelationshipItem(ResourceRelationshipFVO resourceRelationshipItem) {
        if (this.resourceRelationship == null) {
            this.resourceRelationship = new ArrayList<ResourceRelationshipFVO>();
        }
        this.resourceRelationship.add(resourceRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ResourceRelationshipFVO> getResourceRelationship() {
        return this.resourceRelationship;
    }

    public void setResourceRelationship(List<ResourceRelationshipFVO> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
    }

    public ResourceFVO resourceCharacteristic(List<CharacteristicFVO> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
        return this;
    }

    public ResourceFVO addResourceCharacteristicItem(CharacteristicFVO resourceCharacteristicItem) {
        if (this.resourceCharacteristic == null) {
            this.resourceCharacteristic = new ArrayList<CharacteristicFVO>();
        }
        this.resourceCharacteristic.add(resourceCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicFVO> getResourceCharacteristic() {
        return this.resourceCharacteristic;
    }

    public void setResourceCharacteristic(List<CharacteristicFVO> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
    }

    public ResourceFVO attachment(List<AttachmentRefFVO> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ResourceFVO addAttachmentItem(AttachmentRefFVO attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefFVO>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Valid
    @Schema(name="attachment", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<AttachmentRefFVO> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefFVO> attachment) {
        this.attachment = attachment;
    }

    public ResourceFVO resourceSpecification(ResourceSpecificationRefFVO resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Valid
    @Schema(name="resourceSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceSpecificationRefFVO getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRefFVO resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ResourceFVO startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="startOperatingDate", description="A date time( DateTime). The date from which the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startOperatingDate")
    public String getStartOperatingDateString() {
        return this.startOperatingDate != null ? this.startOperatingDate.toString() : null;
    }

    public void setStartOperatingDate(String startOperatingDate) {
        if (startOperatingDate != null) {
            this.startOperatingDate = OffsetDateTime.parse(startOperatingDate);
        }
    }

    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public ResourceFVO resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Schema(name="resourceVersion", description="A field that identifies the specific version of an instance of a resource.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public ResourceFVO activationFeature(List<FeatureFVO> activationFeature) {
        this.activationFeature = activationFeature;
        return this;
    }

    public ResourceFVO addActivationFeatureItem(FeatureFVO activationFeatureItem) {
        if (this.activationFeature == null) {
            this.activationFeature = new ArrayList<FeatureFVO>();
        }
        this.activationFeature.add(activationFeatureItem);
        return this;
    }

    @Valid
    @Schema(name="activationFeature", description="Configuration features", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<FeatureFVO> getActivationFeature() {
        return this.activationFeature;
    }

    public void setActivationFeature(List<FeatureFVO> activationFeature) {
        this.activationFeature = activationFeature;
    }

    public ResourceFVO intent(IntentRefFVO intent) {
        this.intent = intent;
        return this;
    }

    @Valid
    @Schema(name="intent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public IntentRefFVO getIntent() {
        return this.intent;
    }

    public void setIntent(IntentRefFVO intent) {
        this.intent = intent;
    }

    public ResourceFVO externalIdentifier(List<ExternalIdentifierFVO> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    public ResourceFVO addExternalIdentifierItem(ExternalIdentifierFVO externalIdentifierItem) {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifierFVO>();
        }
        this.externalIdentifier.add(externalIdentifierItem);
        return this;
    }

    @Valid
    @Schema(name="externalIdentifier", description="An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ExternalIdentifierFVO> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(List<ExternalIdentifierFVO> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFVO resourceFVO = (ResourceFVO)o;
        return Objects.equals(this.type, resourceFVO.type) && Objects.equals(this.baseType, resourceFVO.baseType) && Objects.equals(this.schemaLocation, resourceFVO.schemaLocation) && Objects.equals(this.href, resourceFVO.href) && Objects.equals(this.uuid, resourceFVO.uuid) && Objects.equals(this.category, resourceFVO.category) && Objects.equals(this.description, resourceFVO.description) && Objects.equals(this.name, resourceFVO.name) && Objects.equals(this.endOperatingDate, resourceFVO.endOperatingDate) && Objects.equals((Object)this.administrativeState, (Object)resourceFVO.administrativeState) && Objects.equals((Object)this.operationalState, (Object)resourceFVO.operationalState) && Objects.equals((Object)this.resourceStatus, (Object)resourceFVO.resourceStatus) && Objects.equals((Object)this.usageState, (Object)resourceFVO.usageState) && Objects.equals(this.validFor, resourceFVO.validFor) && Objects.equals(this.note, resourceFVO.note) && Objects.equals(this.resourceOrderItem, resourceFVO.resourceOrderItem) && Objects.equals(this.place, resourceFVO.place) && Objects.equals(this.relatedParty, resourceFVO.relatedParty) && Objects.equals(this.resourceRelationship, resourceFVO.resourceRelationship) && Objects.equals(this.resourceCharacteristic, resourceFVO.resourceCharacteristic) && Objects.equals(this.attachment, resourceFVO.attachment) && Objects.equals(this.resourceSpecification, resourceFVO.resourceSpecification) && Objects.equals(this.startOperatingDate, resourceFVO.startOperatingDate) && Objects.equals(this.resourceVersion, resourceFVO.resourceVersion) && Objects.equals(this.activationFeature, resourceFVO.activationFeature) && Objects.equals(this.intent, resourceFVO.intent) && Objects.equals(this.externalIdentifier, resourceFVO.externalIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.category, this.description, this.name, this.endOperatingDate, this.administrativeState, this.operationalState, this.resourceStatus, this.usageState, this.validFor, this.note, this.resourceOrderItem, this.place, this.relatedParty, this.resourceRelationship, this.resourceCharacteristic, this.attachment, this.resourceSpecification, this.startOperatingDate, this.resourceVersion, this.activationFeature, this.intent, this.externalIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceFVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    resourceOrderItem: ").append(this.toIndentedString(this.resourceOrderItem)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

