/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRef;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.Note;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.ExternalIdentifier;
import org.etsi.osl.tmf.pm628.model.Feature;
import org.etsi.osl.tmf.pm628.model.IntentRef;
import org.etsi.osl.tmf.pm628.model.LogicalResource;
import org.etsi.osl.tmf.pm628.model.RelatedPartyRefOrPartyRoleRef;
import org.etsi.osl.tmf.pm628.model.RelatedPlaceRef;
import org.etsi.osl.tmf.pm628.model.RelatedResourceOrderItem;
import org.etsi.osl.tmf.pm628.model.ResourceRefOrValue;
import org.etsi.osl.tmf.pm628.model.ResourceRelationship;
import org.etsi.osl.tmf.pm628.model.ResourceStatusType;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationRef;
import org.etsi.osl.tmf.ri639.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.ri639.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.ri639.model.ResourceUsageStateType;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAccessEndpoint.class, name="DataAccessEndpoint"), @JsonSubTypes.Type(value=LogicalResource.class, name="LogicalResource"), @JsonSubTypes.Type(value=Resource.class, name="Resource")})
@Entity(name="PM628_Resource")
public class Resource
extends BaseRootNamedEntity
implements ResourceRefOrValue {
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="description")
    private String description;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime endOperatingDate;
    @JsonProperty(value="administrativeState")
    private ResourceAdministrativeStateType administrativeState;
    @JsonProperty(value="operationalState")
    private ResourceOperationalStateType operationalState;
    @JsonProperty(value="resourceStatus")
    private ResourceStatusType resourceStatus;
    @JsonProperty(value="usageState")
    private ResourceUsageStateType usageState;
    @JsonProperty(value="validFor")
    @Embedded
    private TimePeriod validFor;
    @JsonProperty(value="note")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_note", joinColumns={@JoinColumn(name="resource_uuid")}, inverseJoinColumns={@JoinColumn(name="note_uuid")})
    private List<Note> note = new ArrayList<Note>();
    @JsonProperty(value="resourceOrderItem")
    @Valid
    @ElementCollection(targetClass=RelatedResourceOrderItem.class)
    @CollectionTable(name="pm628_resource_roi", joinColumns={@JoinColumn(name="resource_uid")})
    private List<RelatedResourceOrderItem> resourceOrderItem = new ArrayList<RelatedResourceOrderItem>();
    @JsonProperty(value="place")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private List<RelatedPlaceRef> place = new ArrayList<RelatedPlaceRef>();
    @JsonProperty(value="relatedParty")
    @Valid
    @ElementCollection(targetClass=RelatedPartyRefOrPartyRoleRef.class)
    @CollectionTable(name="pm628_resource_rp", joinColumns={@JoinColumn(name="resource_uuid")})
    private List<RelatedPartyRefOrPartyRoleRef> relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRef>();
    @JsonProperty(value="resourceRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_res_rel", joinColumns={@JoinColumn(name="resource_uuid")}, inverseJoinColumns={@JoinColumn(name="res_rel_uuid")})
    private List<ResourceRelationship> resourceRelationship = new ArrayList<ResourceRelationship>();
    @JsonProperty(value="resourceCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_res_char", joinColumns={@JoinColumn(name="resource_uuid")}, inverseJoinColumns={@JoinColumn(name="res_char_uuid")})
    private List<Characteristic> resourceCharacteristic = new ArrayList<Characteristic>();
    @JsonProperty(value="attachment")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_att", joinColumns={@JoinColumn(name="resource_uuid")}, inverseJoinColumns={@JoinColumn(name="att_uuid")})
    private List<AttachmentRef> attachment = new ArrayList<AttachmentRef>();
    @JsonProperty(value="resourceSpecification")
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="res_spec_id")
    private ResourceSpecificationRef resourceSpecification;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startOperatingDate;
    @JsonProperty(value="resourceVersion")
    private String resourceVersion;
    @JsonProperty(value="activationFeature")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_resource_act_feat", joinColumns={@JoinColumn(name="resource_uuid")}, inverseJoinColumns={@JoinColumn(name="act_feat_uuid")})
    private List<Feature> activationFeature = new ArrayList<Feature>();
    @JsonProperty(value="intent")
    private IntentRef intent;
    @JsonProperty(value="externalIdentifier")
    @Valid
    @ElementCollection(targetClass=ExternalIdentifier.class)
    @CollectionTable(name="pm628_resource_ext_idf", joinColumns={@JoinColumn(name="resource_uuid")})
    private List<ExternalIdentifier> externalIdentifier = new ArrayList<ExternalIdentifier>();

    public Resource() {
    }

    public Resource(String type) {
        this.type = type;
    }

    public Resource category(String category) {
        this.category = category;
        return this;
    }

    @Schema(name="category", description="Category of the concrete resource. e.g Gold, Silver for MSISDN concrete resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Resource description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="free-text description of the resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Resource endOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="endOperatingDate", description="A date time( DateTime). The date till the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="endOperatingDate")
    public String getEndOperatingDateString() {
        return this.endOperatingDate != null ? this.endOperatingDate.toString() : null;
    }

    public void setEndOperatingDate(String endOperatingDate) {
        if (endOperatingDate != null) {
            this.endOperatingDate = OffsetDateTime.parse(endOperatingDate);
        }
    }

    public OffsetDateTime getEndOperatingDate() {
        return this.endOperatingDate;
    }

    public void setEndOperatingDate(OffsetDateTime endOperatingDate) {
        this.endOperatingDate = endOperatingDate;
    }

    public Resource administrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
        return this;
    }

    @Valid
    @Schema(name="administrativeState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceAdministrativeStateType getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(ResourceAdministrativeStateType administrativeState) {
        this.administrativeState = administrativeState;
    }

    public Resource operationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
        return this;
    }

    @Valid
    @Schema(name="operationalState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceOperationalStateType getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceOperationalStateType operationalState) {
        this.operationalState = operationalState;
    }

    public Resource resourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
        return this;
    }

    @Valid
    @Schema(name="resourceStatus", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceStatusType getResourceStatus() {
        return this.resourceStatus;
    }

    public void setResourceStatus(ResourceStatusType resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public Resource usageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
        return this;
    }

    @Valid
    @Schema(name="usageState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceUsageStateType getUsageState() {
        return this.usageState;
    }

    public void setUsageState(ResourceUsageStateType usageState) {
        this.usageState = usageState;
    }

    public Resource validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public Resource note(List<Note> note) {
        this.note = note;
        return this;
    }

    public Resource addNoteItem(Note noteItem) {
        if (this.note == null) {
            this.note = new ArrayList<Note>();
        }
        this.note.add(noteItem);
        return this;
    }

    @Valid
    @Schema(name="note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Note> getNote() {
        return this.note;
    }

    public void setNote(List<Note> note) {
        this.note = note;
    }

    public Resource resourceOrderItem(List<RelatedResourceOrderItem> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
        return this;
    }

    public Resource addResourceOrderItemItem(RelatedResourceOrderItem resourceOrderItemItem) {
        if (this.resourceOrderItem == null) {
            this.resourceOrderItem = new ArrayList<RelatedResourceOrderItem>();
        }
        this.resourceOrderItem.add(resourceOrderItemItem);
        return this;
    }

    @Valid
    @Schema(name="resourceOrderItem", description="A list of resource order items related to this resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedResourceOrderItem> getResourceOrderItem() {
        return this.resourceOrderItem;
    }

    public void setResourceOrderItem(List<RelatedResourceOrderItem> resourceOrderItem) {
        this.resourceOrderItem = resourceOrderItem;
    }

    public Resource place(List<RelatedPlaceRef> place) {
        this.place = place;
        return this;
    }

    public Resource addPlaceItem(RelatedPlaceRef placeItem) {
        if (this.place == null) {
            this.place = new ArrayList<RelatedPlaceRef>();
        }
        this.place.add(placeItem);
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPlaceRef> getPlace() {
        return this.place;
    }

    public void setPlace(List<RelatedPlaceRef> place) {
        this.place = place;
    }

    public Resource relatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Resource addRelatedPartyItem(RelatedPartyRefOrPartyRoleRef relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRef>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPartyRefOrPartyRoleRef> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Resource resourceRelationship(List<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this;
    }

    public Resource addResourceRelationshipItem(ResourceRelationship resourceRelationshipItem) {
        if (this.resourceRelationship == null) {
            this.resourceRelationship = new ArrayList<ResourceRelationship>();
        }
        this.resourceRelationship.add(resourceRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="resourceRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ResourceRelationship> getResourceRelationship() {
        return this.resourceRelationship;
    }

    public void setResourceRelationship(List<ResourceRelationship> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
    }

    public Resource resourceCharacteristic(List<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
        return this;
    }

    public Resource addResourceCharacteristicItem(Characteristic resourceCharacteristicItem) {
        if (this.resourceCharacteristic == null) {
            this.resourceCharacteristic = new ArrayList<Characteristic>();
        }
        this.resourceCharacteristic.add(resourceCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="resourceCharacteristic", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Characteristic> getResourceCharacteristic() {
        return this.resourceCharacteristic;
    }

    public void setResourceCharacteristic(List<Characteristic> resourceCharacteristic) {
        this.resourceCharacteristic = resourceCharacteristic;
    }

    public Resource attachment(List<AttachmentRef> attachment) {
        this.attachment = attachment;
        return this;
    }

    public Resource addAttachmentItem(AttachmentRef attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRef>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Valid
    @Schema(name="attachment", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<AttachmentRef> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRef> attachment) {
        this.attachment = attachment;
    }

    public Resource resourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
        return this;
    }

    @Valid
    @Schema(name="resourceSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ResourceSpecificationRef getResourceSpecification() {
        return this.resourceSpecification;
    }

    public void setResourceSpecification(ResourceSpecificationRef resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public Resource startOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
        return this;
    }

    @Valid
    @Schema(name="startOperatingDate", description="A date time( DateTime). The date from which the resource is operating", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startOperatingDate")
    public String getStartOperatingDateString() {
        return this.startOperatingDate != null ? this.startOperatingDate.toString() : null;
    }

    public void setStartOperatingDate(String startOperatingDate) {
        if (startOperatingDate != null) {
            this.startOperatingDate = OffsetDateTime.parse(startOperatingDate);
        }
    }

    public OffsetDateTime getStartOperatingDate() {
        return this.startOperatingDate;
    }

    public void setStartOperatingDate(OffsetDateTime startOperatingDate) {
        this.startOperatingDate = startOperatingDate;
    }

    public Resource resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Schema(name="resourceVersion", description="A field that identifies the specific version of an instance of a resource.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public Resource activationFeature(List<Feature> activationFeature) {
        this.activationFeature = activationFeature;
        return this;
    }

    public Resource addActivationFeatureItem(Feature activationFeatureItem) {
        if (this.activationFeature == null) {
            this.activationFeature = new ArrayList<Feature>();
        }
        this.activationFeature.add(activationFeatureItem);
        return this;
    }

    @Valid
    @Schema(name="activationFeature", description="Configuration features", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Feature> getActivationFeature() {
        return this.activationFeature;
    }

    public void setActivationFeature(List<Feature> activationFeature) {
        this.activationFeature = activationFeature;
    }

    public Resource intent(IntentRef intent) {
        this.intent = intent;
        return this;
    }

    @Valid
    @Schema(name="intent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public IntentRef getIntent() {
        return this.intent;
    }

    public void setIntent(IntentRef intent) {
        this.intent = intent;
    }

    public Resource externalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    public Resource addExternalIdentifierItem(ExternalIdentifier externalIdentifierItem) {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifier>();
        }
        this.externalIdentifier.add(externalIdentifierItem);
        return this;
    }

    @Valid
    @Schema(name="externalIdentifier", description="An identification of this resource that is owned by or originates in a software system different from the current system. The structure identifies the system itself, the nature of the resource within the system and the unique ID of the resource within the system. It is anticipated that multiple external IDs can be held for a single resource, e.g. if the resource passed through multiple systems on the way to the current system.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<ExternalIdentifier> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(List<ExternalIdentifier> externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.type, resource.type) && Objects.equals(this.baseType, resource.baseType) && Objects.equals(this.schemaLocation, resource.schemaLocation) && Objects.equals(this.href, resource.href) && Objects.equals(this.uuid, resource.uuid) && Objects.equals(this.category, resource.category) && Objects.equals(this.description, resource.description) && Objects.equals(this.name, resource.name) && Objects.equals(this.endOperatingDate, resource.endOperatingDate) && Objects.equals((Object)this.administrativeState, (Object)resource.administrativeState) && Objects.equals((Object)this.operationalState, (Object)resource.operationalState) && Objects.equals((Object)this.resourceStatus, (Object)resource.resourceStatus) && Objects.equals((Object)this.usageState, (Object)resource.usageState) && Objects.equals(this.validFor, resource.validFor) && Objects.equals(this.note, resource.note) && Objects.equals(this.resourceOrderItem, resource.resourceOrderItem) && Objects.equals(this.place, resource.place) && Objects.equals(this.relatedParty, resource.relatedParty) && Objects.equals(this.resourceRelationship, resource.resourceRelationship) && Objects.equals(this.resourceCharacteristic, resource.resourceCharacteristic) && Objects.equals(this.attachment, resource.attachment) && Objects.equals(this.resourceSpecification, resource.resourceSpecification) && Objects.equals(this.startOperatingDate, resource.startOperatingDate) && Objects.equals(this.resourceVersion, resource.resourceVersion) && Objects.equals(this.activationFeature, resource.activationFeature) && Objects.equals(this.intent, resource.intent) && Objects.equals(this.externalIdentifier, resource.externalIdentifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.category, this.description, this.name, this.endOperatingDate, this.administrativeState, this.operationalState, this.resourceStatus, this.usageState, this.validFor, this.note, this.resourceOrderItem, this.place, this.relatedParty, this.resourceRelationship, this.resourceCharacteristic, this.attachment, this.resourceSpecification, this.startOperatingDate, this.resourceVersion, this.activationFeature, this.intent, this.externalIdentifier});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    endOperatingDate: ").append(this.toIndentedString(this.endOperatingDate)).append("\n");
        sb.append("    administrativeState: ").append(this.toIndentedString((Object)this.administrativeState)).append("\n");
        sb.append("    operationalState: ").append(this.toIndentedString((Object)this.operationalState)).append("\n");
        sb.append("    resourceStatus: ").append(this.toIndentedString((Object)this.resourceStatus)).append("\n");
        sb.append("    usageState: ").append(this.toIndentedString((Object)this.usageState)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    resourceOrderItem: ").append(this.toIndentedString(this.resourceOrderItem)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    resourceRelationship: ").append(this.toIndentedString(this.resourceRelationship)).append("\n");
        sb.append("    resourceCharacteristic: ").append(this.toIndentedString(this.resourceCharacteristic)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    resourceSpecification: ").append(this.toIndentedString(this.resourceSpecification)).append("\n");
        sb.append("    startOperatingDate: ").append(this.toIndentedString(this.startOperatingDate)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    activationFeature: ").append(this.toIndentedString(this.activationFeature)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

