/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.po622.model.OrderItemActionType;

@Embeddable
public class RelatedResourceOrderItem {
    @JsonProperty(value="@type")
    @Column(name="rroi_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="rroi_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="rroi_schema_location")
    private String schemaLocation;
    @JsonProperty(value="@referredType")
    @Column(name="rroi_referred_type")
    private String referredType;
    @JsonProperty(value="resourceOrderHref")
    private String resourceOrderHref;
    @JsonProperty(value="resourceOrderId")
    private String resourceOrderId;
    @JsonProperty(value="itemAction")
    private OrderItemActionType itemAction;
    @JsonProperty(value="itemId")
    private String itemId;
    @JsonProperty(value="role")
    private String role;

    public RelatedResourceOrderItem() {
    }

    public RelatedResourceOrderItem(String type) {
        this.type = type;
    }

    public RelatedResourceOrderItem type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public RelatedResourceOrderItem baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public RelatedResourceOrderItem schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public RelatedResourceOrderItem referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public RelatedResourceOrderItem resourceOrderHref(String resourceOrderHref) {
        this.resourceOrderHref = resourceOrderHref;
        return this;
    }

    @Schema(name="resourceOrderHref", description="Reference of the related entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getResourceOrderHref() {
        return this.resourceOrderHref;
    }

    public void setResourceOrderHref(String resourceOrderHref) {
        this.resourceOrderHref = resourceOrderHref;
    }

    public RelatedResourceOrderItem resourceOrderId(String resourceOrderId) {
        this.resourceOrderId = resourceOrderId;
        return this;
    }

    @Schema(name="resourceOrderId", description="Unique identifier of a related entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getResourceOrderId() {
        return this.resourceOrderId;
    }

    public void setResourceOrderId(String resourceOrderId) {
        this.resourceOrderId = resourceOrderId;
    }

    public RelatedResourceOrderItem itemAction(OrderItemActionType itemAction) {
        this.itemAction = itemAction;
        return this;
    }

    @Valid
    @Schema(name="itemAction", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OrderItemActionType getItemAction() {
        return this.itemAction;
    }

    public void setItemAction(OrderItemActionType itemAction) {
        this.itemAction = itemAction;
    }

    public RelatedResourceOrderItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Schema(name="itemId", description="Identifier of the order item where the resource was managed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public RelatedResourceOrderItem role(String role) {
        this.role = role;
        return this;
    }

    @Schema(name="role", description="role of the resource order item for this resource", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedResourceOrderItem relatedResourceOrderItem = (RelatedResourceOrderItem)o;
        return Objects.equals(this.type, relatedResourceOrderItem.type) && Objects.equals(this.baseType, relatedResourceOrderItem.baseType) && Objects.equals(this.schemaLocation, relatedResourceOrderItem.schemaLocation) && Objects.equals(this.referredType, relatedResourceOrderItem.referredType) && Objects.equals(this.resourceOrderHref, relatedResourceOrderItem.resourceOrderHref) && Objects.equals(this.resourceOrderId, relatedResourceOrderItem.resourceOrderId) && Objects.equals((Object)this.itemAction, (Object)relatedResourceOrderItem.itemAction) && Objects.equals(this.itemId, relatedResourceOrderItem.itemId) && Objects.equals(this.role, relatedResourceOrderItem.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.referredType, this.resourceOrderHref, this.resourceOrderId, this.itemAction, this.itemId, this.role});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedResourceOrderItem {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("    resourceOrderHref: ").append(this.toIndentedString(this.resourceOrderHref)).append("\n");
        sb.append("    resourceOrderId: ").append(this.toIndentedString(this.resourceOrderId)).append("\n");
        sb.append("    itemAction: ").append(this.toIndentedString((Object)this.itemAction)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

