/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pcm620.model.PlaceRef;

@Entity(name="PM628_RelPlaceRef")
public class RelatedPlaceRef
extends BaseRootEntity {
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="place")
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="place_id")
    private PlaceRef place;

    public RelatedPlaceRef() {
    }

    public RelatedPlaceRef(String type) {
        this.type = type;
    }

    public RelatedPlaceRef type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public RelatedPlaceRef baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Override
    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public RelatedPlaceRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Override
    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public RelatedPlaceRef role(String role) {
        this.role = role;
        return this;
    }

    @Schema(name="role", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPlaceRef place(PlaceRef place) {
        this.place = place;
        return this;
    }

    @Valid
    @Schema(name="place", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public PlaceRef getPlace() {
        return this.place;
    }

    public void setPlace(PlaceRef place) {
        this.place = place;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPlaceRef relatedPlaceRef = (RelatedPlaceRef)o;
        return Objects.equals(this.type, relatedPlaceRef.type) && Objects.equals(this.baseType, relatedPlaceRef.baseType) && Objects.equals(this.schemaLocation, relatedPlaceRef.schemaLocation) && Objects.equals(this.role, relatedPlaceRef.role) && Objects.equals(this.place, relatedPlaceRef.place);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.role, this.place);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPlaceRef {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    place: ").append(this.toIndentedString(this.place)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

