/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.PartyRefOrPartyRoleRefMVO;

public class RelatedPartyRefOrPartyRoleRefMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="partyOrPartyRole")
    private PartyRefOrPartyRoleRefMVO partyOrPartyRole;

    public RelatedPartyRefOrPartyRoleRefMVO() {
    }

    public RelatedPartyRefOrPartyRoleRefMVO(String type, String role) {
        this.type = type;
        this.role = role;
    }

    public RelatedPartyRefOrPartyRoleRefMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public RelatedPartyRefOrPartyRoleRefMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public RelatedPartyRefOrPartyRoleRefMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public RelatedPartyRefOrPartyRoleRefMVO role(String role) {
        this.role = role;
        return this;
    }

    @NotNull
    @Schema(name="role", description="Role played by the related party or party role in the context of the specific entity it is linked to. Such as 'initiator', 'customer',  'salesAgent', 'user'", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPartyRefOrPartyRoleRefMVO partyOrPartyRole(PartyRefOrPartyRoleRefMVO partyOrPartyRole) {
        this.partyOrPartyRole = partyOrPartyRole;
        return this;
    }

    @Valid
    @Schema(name="partyOrPartyRole", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public PartyRefOrPartyRoleRefMVO getPartyOrPartyRole() {
        return this.partyOrPartyRole;
    }

    public void setPartyOrPartyRole(PartyRefOrPartyRoleRefMVO partyOrPartyRole) {
        this.partyOrPartyRole = partyOrPartyRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPartyRefOrPartyRoleRefMVO relatedPartyRefOrPartyRoleRefMVO = (RelatedPartyRefOrPartyRoleRefMVO)o;
        return Objects.equals(this.type, relatedPartyRefOrPartyRoleRefMVO.type) && Objects.equals(this.baseType, relatedPartyRefOrPartyRoleRefMVO.baseType) && Objects.equals(this.schemaLocation, relatedPartyRefOrPartyRoleRefMVO.schemaLocation) && Objects.equals(this.role, relatedPartyRefOrPartyRoleRefMVO.role) && Objects.equals(this.partyOrPartyRole, relatedPartyRefOrPartyRoleRefMVO.partyOrPartyRole);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.role, this.partyOrPartyRole);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPartyRefOrPartyRoleRefMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    partyOrPartyRole: ").append(this.toIndentedString(this.partyOrPartyRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

