/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Embeddable;
import jakarta.persistence.JoinColumn;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.PartyRef;
import org.etsi.osl.tmf.pm628.model.PartyRefOrPartyRoleRef;
import org.etsi.osl.tmf.pm628.model.PartyRoleRef;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;

@Embeddable
public class RelatedPartyRefOrPartyRoleRef {
    @JsonProperty(value="@type")
    @Column(name="rproprr_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="rproprr_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="rproprr_schema_location")
    private String schemaLocation;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="partyOrPartyRole")
    @Any
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="pr", entity=PartyRef.class), @AnyDiscriminatorValue(discriminator="prr", entity=PartyRoleRef.class)})
    @AnyKeyJavaClass(value=String.class)
    @Column(name="party_or_party_role_type")
    @JoinColumn(name="party_ref_or_party_role_ref_id")
    private PartyRefOrPartyRoleRef partyOrPartyRole;

    public RelatedPartyRefOrPartyRoleRef() {
    }

    public RelatedPartyRefOrPartyRoleRef(String type) {
        this.type = type;
    }

    public RelatedPartyRefOrPartyRoleRef type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public RelatedPartyRefOrPartyRoleRef baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public RelatedPartyRefOrPartyRoleRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public RelatedPartyRefOrPartyRoleRef role(String role) {
        this.role = role;
        return this;
    }

    @Schema(name="role", description="Role played by the related party or party role in the context of the specific entity it is linked to. Such as 'initiator', 'customer',  'salesAgent', 'user'", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public RelatedPartyRefOrPartyRoleRef partyOrPartyRole(PartyRefOrPartyRoleRef partyOrPartyRole) {
        this.partyOrPartyRole = partyOrPartyRole;
        return this;
    }

    @Valid
    @Schema(name="partyOrPartyRole", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public PartyRefOrPartyRoleRef getPartyOrPartyRole() {
        return this.partyOrPartyRole;
    }

    public void setPartyOrPartyRole(PartyRefOrPartyRoleRef partyOrPartyRole) {
        this.partyOrPartyRole = partyOrPartyRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelatedPartyRefOrPartyRoleRef relatedPartyRefOrPartyRoleRef = (RelatedPartyRefOrPartyRoleRef)o;
        return Objects.equals(this.type, relatedPartyRefOrPartyRoleRef.type) && Objects.equals(this.baseType, relatedPartyRefOrPartyRoleRef.baseType) && Objects.equals(this.schemaLocation, relatedPartyRefOrPartyRoleRef.schemaLocation) && Objects.equals(this.role, relatedPartyRefOrPartyRoleRef.role) && Objects.equals(this.partyOrPartyRole, relatedPartyRefOrPartyRoleRef.partyOrPartyRole);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.role, this.partyOrPartyRole);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelatedPartyRefOrPartyRoleRef {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    partyOrPartyRole: ").append(this.toIndentedString(this.partyOrPartyRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

