/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;

@Entity(name="PM628_PolicyRef")
public class PolicyRef
extends BaseRootNamedEntity {
    @JsonProperty(value="@referredType")
    private String referredType;
    @JsonProperty(value="version")
    private String version;

    public PolicyRef() {
    }

    public PolicyRef(String type, String uuid) {
        this.type = type;
        this.uuid = uuid;
    }

    public PolicyRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public PolicyRef version(String version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRef policyRef = (PolicyRef)o;
        return Objects.equals(this.type, policyRef.type) && Objects.equals(this.baseType, policyRef.baseType) && Objects.equals(this.schemaLocation, policyRef.schemaLocation) && Objects.equals(this.href, policyRef.href) && Objects.equals(this.uuid, policyRef.uuid) && Objects.equals(this.name, policyRef.name) && Objects.equals(this.referredType, policyRef.referredType) && Objects.equals(this.version, policyRef.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.referredType, this.version);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyRef {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

