/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobRef;
import org.etsi.osl.tmf.pm628.model.PerformanceMeasurementAtomic;
import org.etsi.osl.tmf.pm628.model.PerformanceMeasurementGroup;
import org.etsi.osl.tmf.pm628.model.PerformanceMeasurementRefOrValue;
import org.etsi.osl.tmf.pm628.model.PerformanceMeasurementRelationship;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PerformanceMeasurement.class, name="PerformanceMeasurement"), @JsonSubTypes.Type(value=PerformanceMeasurementAtomic.class, name="PerformanceMeasurementAtomic"), @JsonSubTypes.Type(value=PerformanceMeasurementGroup.class, name="PerformanceMeasurementGroup")})
public class PerformanceMeasurement
implements PerformanceMeasurementRefOrValue {
    private String atType;
    private String atBaseType;
    private String atSchemaLocation;
    private String href;
    private String id;
    private String description;
    private MeasurementCollectionJobRef measurementCollectionJob;
    private TimePeriod validFor;
    @Valid
    private List<PerformanceMeasurementRelationship> relatedMeasurement = new ArrayList<PerformanceMeasurementRelationship>();
    private Object tag;

    public PerformanceMeasurement() {
    }

    public PerformanceMeasurement(String atType) {
        this.atType = atType;
    }

    public PerformanceMeasurement atType(String atType) {
        this.atType = atType;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public PerformanceMeasurement atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public PerformanceMeasurement atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public PerformanceMeasurement href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="href")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PerformanceMeasurement id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PerformanceMeasurement description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="A free-text description of the performance measurement", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PerformanceMeasurement measurementCollectionJob(MeasurementCollectionJobRef measurementCollectionJob) {
        this.measurementCollectionJob = measurementCollectionJob;
        return this;
    }

    @Valid
    @Schema(name="measurementCollectionJob", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="measurementCollectionJob")
    public MeasurementCollectionJobRef getMeasurementCollectionJob() {
        return this.measurementCollectionJob;
    }

    public void setMeasurementCollectionJob(MeasurementCollectionJobRef measurementCollectionJob) {
        this.measurementCollectionJob = measurementCollectionJob;
    }

    public PerformanceMeasurement validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="validFor")
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public PerformanceMeasurement relatedMeasurement(List<PerformanceMeasurementRelationship> relatedMeasurement) {
        this.relatedMeasurement = relatedMeasurement;
        return this;
    }

    public PerformanceMeasurement addRelatedMeasurementItem(PerformanceMeasurementRelationship relatedMeasurementItem) {
        if (this.relatedMeasurement == null) {
            this.relatedMeasurement = new ArrayList<PerformanceMeasurementRelationship>();
        }
        this.relatedMeasurement.add(relatedMeasurementItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="relatedMeasurement", description="related Performance measurements array", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="relatedMeasurement")
    public @Valid @Size(min=0) List<PerformanceMeasurementRelationship> getRelatedMeasurement() {
        return this.relatedMeasurement;
    }

    public void setRelatedMeasurement(List<PerformanceMeasurementRelationship> relatedMeasurement) {
        this.relatedMeasurement = relatedMeasurement;
    }

    public PerformanceMeasurement tag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Schema(name="tag", description="The optional tag object attached to this entire measurement", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tag")
    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)o;
        return Objects.equals(this.atType, performanceMeasurement.atType) && Objects.equals(this.atBaseType, performanceMeasurement.atBaseType) && Objects.equals(this.atSchemaLocation, performanceMeasurement.atSchemaLocation) && Objects.equals(this.href, performanceMeasurement.href) && Objects.equals(this.id, performanceMeasurement.id) && Objects.equals(this.description, performanceMeasurement.description) && Objects.equals(this.measurementCollectionJob, performanceMeasurement.measurementCollectionJob) && Objects.equals(this.validFor, performanceMeasurement.validFor) && Objects.equals(this.relatedMeasurement, performanceMeasurement.relatedMeasurement) && Objects.equals(this.tag, performanceMeasurement.tag);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation, this.href, this.id, this.description, this.measurementCollectionJob, this.validFor, this.relatedMeasurement, this.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceMeasurement {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    measurementCollectionJob: ").append(this.toIndentedString(this.measurementCollectionJob)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    relatedMeasurement: ").append(this.toIndentedString(this.relatedMeasurement)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

