/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.CollectionType;
import org.etsi.osl.tmf.pm628.model.IndicatorType;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecRelationshipMVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValueMVO;

public class PerformanceIndicatorSpecificationMVO
implements PerformanceIndicatorSpecificationRefOrValueMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="perspective")
    private String perspective;
    @JsonProperty(value="indicatorCategory")
    private String indicatorCategory;
    @JsonProperty(value="indicatorType")
    private IndicatorType indicatorType;
    @JsonProperty(value="derivationAlgorithm")
    private String derivationAlgorithm;
    @JsonProperty(value="derivationMethod")
    private String derivationMethod;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;
    @JsonProperty(value="collectionType")
    private CollectionType collectionType;
    @JsonProperty(value="indicatorUnit")
    private String indicatorUnit;
    @JsonProperty(value="performanceIndicatorSpecRelationship")
    @Valid
    private List<PerformanceIndicatorSpecRelationshipMVO> performanceIndicatorSpecRelationship;

    public PerformanceIndicatorSpecificationMVO() {
    }

    public PerformanceIndicatorSpecificationMVO(String type) {
        this.type = type;
    }

    public PerformanceIndicatorSpecificationMVO type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PerformanceIndicatorSpecificationMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getbaseType() {
        return this.baseType;
    }

    public void setbaseType(String baseType) {
        this.baseType = baseType;
    }

    public PerformanceIndicatorSpecificationMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public PerformanceIndicatorSpecificationMVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PerformanceIndicatorSpecificationMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public PerformanceIndicatorSpecificationMVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="A word, term, or phrase by which a PerformanceIndicatorSpecification is known and distinguished from other PerformanceIndicatorSpecifications.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PerformanceIndicatorSpecificationMVO description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="A narrative that explains in detail what the PerformanceIndicatorSpecification is.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PerformanceIndicatorSpecificationMVO perspective(String perspective) {
        this.perspective = perspective;
        return this;
    }

    @Schema(name="perspective", description="The point of view for the PerformanceIndicatorSpecification, such as a single user instance or aggregation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPerspective() {
        return this.perspective;
    }

    public void setPerspective(String perspective) {
        this.perspective = perspective;
    }

    public PerformanceIndicatorSpecificationMVO indicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
        return this;
    }

    @Schema(name="indicatorCategory", description="A grouping or set of PerformanceIndicatorSpecifications that are classified together because of common characteristics, such as technology specific, service specific, or technology/service independent.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getIndicatorCategory() {
        return this.indicatorCategory;
    }

    public void setIndicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
    }

    public PerformanceIndicatorSpecificationMVO indicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    @Valid
    @Schema(name="indicatorType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public IndicatorType getIndicatorType() {
        return this.indicatorType;
    }

    public void setIndicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
    }

    public PerformanceIndicatorSpecificationMVO derivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
        return this;
    }

    @Schema(name="derivationAlgorithm", description="A step-by-step procedure used to calculate the value of PerformanceIndicator.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationAlgorithm() {
        return this.derivationAlgorithm;
    }

    public void setDerivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
    }

    public PerformanceIndicatorSpecificationMVO derivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
        return this;
    }

    @Schema(name="derivationMethod", description="For simple calculations, the method used to calculate the value of a PerformanceIndicator, such as average, minimum, maximum, sum and so forth.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public void setDerivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
    }

    public PerformanceIndicatorSpecificationMVO validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public PerformanceIndicatorSpecificationMVO collectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    @Valid
    @Schema(name="collectionType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public PerformanceIndicatorSpecificationMVO indicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
        return this;
    }

    @Schema(name="indicatorUnit", description="The unit by which the indicator is measured. For example, seconds, KBs, rate per second, etc.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getIndicatorUnit() {
        return this.indicatorUnit;
    }

    public void setIndicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
    }

    public PerformanceIndicatorSpecificationMVO performanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationshipMVO> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
        return this;
    }

    public PerformanceIndicatorSpecificationMVO addPerformanceIndicatorSpecRelationshipItem(PerformanceIndicatorSpecRelationshipMVO performanceIndicatorSpecRelationshipItem) {
        if (this.performanceIndicatorSpecRelationship == null) {
            this.performanceIndicatorSpecRelationship = new ArrayList<PerformanceIndicatorSpecRelationshipMVO>();
        }
        this.performanceIndicatorSpecRelationship.add(performanceIndicatorSpecRelationshipItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorSpecRelationshipMVO> getPerformanceIndicatorSpecRelationship() {
        return this.performanceIndicatorSpecRelationship;
    }

    public void setPerformanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationshipMVO> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceIndicatorSpecificationMVO performanceIndicatorSpecificationMVO = (PerformanceIndicatorSpecificationMVO)o;
        return Objects.equals(this.type, performanceIndicatorSpecificationMVO.type) && Objects.equals(this.baseType, performanceIndicatorSpecificationMVO.baseType) && Objects.equals(this.schemaLocation, performanceIndicatorSpecificationMVO.schemaLocation) && Objects.equals(this.href, performanceIndicatorSpecificationMVO.href) && Objects.equals(this.uuid, performanceIndicatorSpecificationMVO.uuid) && Objects.equals(this.name, performanceIndicatorSpecificationMVO.name) && Objects.equals(this.description, performanceIndicatorSpecificationMVO.description) && Objects.equals(this.perspective, performanceIndicatorSpecificationMVO.perspective) && Objects.equals(this.indicatorCategory, performanceIndicatorSpecificationMVO.indicatorCategory) && Objects.equals((Object)this.indicatorType, (Object)performanceIndicatorSpecificationMVO.indicatorType) && Objects.equals(this.derivationAlgorithm, performanceIndicatorSpecificationMVO.derivationAlgorithm) && Objects.equals(this.derivationMethod, performanceIndicatorSpecificationMVO.derivationMethod) && Objects.equals(this.validFor, performanceIndicatorSpecificationMVO.validFor) && Objects.equals((Object)this.collectionType, (Object)performanceIndicatorSpecificationMVO.collectionType) && Objects.equals(this.indicatorUnit, performanceIndicatorSpecificationMVO.indicatorUnit) && Objects.equals(this.performanceIndicatorSpecRelationship, performanceIndicatorSpecificationMVO.performanceIndicatorSpecRelationship);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.description, this.perspective, this.indicatorCategory, this.indicatorType, this.derivationAlgorithm, this.derivationMethod, this.validFor, this.collectionType, this.indicatorUnit, this.performanceIndicatorSpecRelationship});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceIndicatorSpecificationMVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    perspective: ").append(this.toIndentedString(this.perspective)).append("\n");
        sb.append("    indicatorCategory: ").append(this.toIndentedString(this.indicatorCategory)).append("\n");
        sb.append("    indicatorType: ").append(this.toIndentedString((Object)this.indicatorType)).append("\n");
        sb.append("    derivationAlgorithm: ").append(this.toIndentedString(this.derivationAlgorithm)).append("\n");
        sb.append("    derivationMethod: ").append(this.toIndentedString(this.derivationMethod)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    collectionType: ").append(this.toIndentedString((Object)this.collectionType)).append("\n");
        sb.append("    indicatorUnit: ").append(this.toIndentedString(this.indicatorUnit)).append("\n");
        sb.append("    performanceIndicatorSpecRelationship: ").append(this.toIndentedString(this.performanceIndicatorSpecRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

