/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.CollectionType;
import org.etsi.osl.tmf.pm628.model.IndicatorType;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecRelationshipFVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValueFVO;

public class PerformanceIndicatorSpecificationFVO
implements PerformanceIndicatorSpecificationRefOrValueFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="perspective")
    private String perspective;
    @JsonProperty(value="indicatorCategory")
    private String indicatorCategory;
    @JsonProperty(value="indicatorType")
    private IndicatorType indicatorType;
    @JsonProperty(value="derivationAlgorithm")
    private String derivationAlgorithm;
    @JsonProperty(value="derivationMethod")
    private String derivationMethod;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;
    @JsonProperty(value="collectionType")
    private CollectionType collectionType;
    @JsonProperty(value="indicatorUnit")
    private String indicatorUnit;
    @JsonProperty(value="performanceIndicatorSpecRelationship")
    @Valid
    private List<PerformanceIndicatorSpecRelationshipFVO> performanceIndicatorSpecRelationship = new ArrayList<PerformanceIndicatorSpecRelationshipFVO>();

    public PerformanceIndicatorSpecificationFVO() {
    }

    public PerformanceIndicatorSpecificationFVO(String type, String name, String indicatorCategory, IndicatorType indicatorType, CollectionType collectionType, String indicatorUnit) {
        this.type = type;
        this.name = name;
        this.indicatorCategory = indicatorCategory;
        this.indicatorType = indicatorType;
        this.collectionType = collectionType;
        this.indicatorUnit = indicatorUnit;
    }

    public PerformanceIndicatorSpecificationFVO type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PerformanceIndicatorSpecificationFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public PerformanceIndicatorSpecificationFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public PerformanceIndicatorSpecificationFVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PerformanceIndicatorSpecificationFVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public PerformanceIndicatorSpecificationFVO name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="A word, term, or phrase by which a PerformanceIndicatorSpecification is known and distinguished from other PerformanceIndicatorSpecifications.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PerformanceIndicatorSpecificationFVO description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="A narrative that explains in detail what the PerformanceIndicatorSpecification is.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PerformanceIndicatorSpecificationFVO perspective(String perspective) {
        this.perspective = perspective;
        return this;
    }

    @Schema(name="perspective", description="The point of view for the PerformanceIndicatorSpecification, such as a single user instance or aggregation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPerspective() {
        return this.perspective;
    }

    public void setPerspective(String perspective) {
        this.perspective = perspective;
    }

    public PerformanceIndicatorSpecificationFVO indicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
        return this;
    }

    @NotNull
    @Schema(name="indicatorCategory", description="A grouping or set of PerformanceIndicatorSpecifications that are classified together because of common characteristics, such as technology specific, service specific, or technology/service independent.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getIndicatorCategory() {
        return this.indicatorCategory;
    }

    public void setIndicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
    }

    public PerformanceIndicatorSpecificationFVO indicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="indicatorType", requiredMode=Schema.RequiredMode.REQUIRED)
    public IndicatorType getIndicatorType() {
        return this.indicatorType;
    }

    public void setIndicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
    }

    public PerformanceIndicatorSpecificationFVO derivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
        return this;
    }

    @Schema(name="derivationAlgorithm", description="A step-by-step procedure used to calculate the value of PerformanceIndicator.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationAlgorithm() {
        return this.derivationAlgorithm;
    }

    public void setDerivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
    }

    public PerformanceIndicatorSpecificationFVO derivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
        return this;
    }

    @Schema(name="derivationMethod", description="For simple calculations, the method used to calculate the value of a PerformanceIndicator, such as average, minimum, maximum, sum and so forth.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public void setDerivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
    }

    public PerformanceIndicatorSpecificationFVO validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public PerformanceIndicatorSpecificationFVO collectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="collectionType", requiredMode=Schema.RequiredMode.REQUIRED)
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public PerformanceIndicatorSpecificationFVO indicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
        return this;
    }

    @NotNull
    @Schema(name="indicatorUnit", description="The unit by which the indicator is measured. For example, seconds, KBs, rate per second, etc.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getIndicatorUnit() {
        return this.indicatorUnit;
    }

    public void setIndicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
    }

    public PerformanceIndicatorSpecificationFVO performanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationshipFVO> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
        return this;
    }

    public PerformanceIndicatorSpecificationFVO addPerformanceIndicatorSpecRelationshipItem(PerformanceIndicatorSpecRelationshipFVO performanceIndicatorSpecRelationshipItem) {
        if (this.performanceIndicatorSpecRelationship == null) {
            this.performanceIndicatorSpecRelationship = new ArrayList<PerformanceIndicatorSpecRelationshipFVO>();
        }
        this.performanceIndicatorSpecRelationship.add(performanceIndicatorSpecRelationshipItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorSpecRelationshipFVO> getPerformanceIndicatorSpecRelationship() {
        return this.performanceIndicatorSpecRelationship;
    }

    public void setPerformanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationshipFVO> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceIndicatorSpecificationFVO performanceIndicatorSpecificationFVO = (PerformanceIndicatorSpecificationFVO)o;
        return Objects.equals(this.type, performanceIndicatorSpecificationFVO.type) && Objects.equals(this.baseType, performanceIndicatorSpecificationFVO.baseType) && Objects.equals(this.schemaLocation, performanceIndicatorSpecificationFVO.schemaLocation) && Objects.equals(this.href, performanceIndicatorSpecificationFVO.href) && Objects.equals(this.uuid, performanceIndicatorSpecificationFVO.uuid) && Objects.equals(this.name, performanceIndicatorSpecificationFVO.name) && Objects.equals(this.description, performanceIndicatorSpecificationFVO.description) && Objects.equals(this.perspective, performanceIndicatorSpecificationFVO.perspective) && Objects.equals(this.indicatorCategory, performanceIndicatorSpecificationFVO.indicatorCategory) && Objects.equals((Object)this.indicatorType, (Object)performanceIndicatorSpecificationFVO.indicatorType) && Objects.equals(this.derivationAlgorithm, performanceIndicatorSpecificationFVO.derivationAlgorithm) && Objects.equals(this.derivationMethod, performanceIndicatorSpecificationFVO.derivationMethod) && Objects.equals(this.validFor, performanceIndicatorSpecificationFVO.validFor) && Objects.equals((Object)this.collectionType, (Object)performanceIndicatorSpecificationFVO.collectionType) && Objects.equals(this.indicatorUnit, performanceIndicatorSpecificationFVO.indicatorUnit) && Objects.equals(this.performanceIndicatorSpecRelationship, performanceIndicatorSpecificationFVO.performanceIndicatorSpecRelationship);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.description, this.perspective, this.indicatorCategory, this.indicatorType, this.derivationAlgorithm, this.derivationMethod, this.validFor, this.collectionType, this.indicatorUnit, this.performanceIndicatorSpecRelationship});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceIndicatorSpecificationFVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    perspective: ").append(this.toIndentedString(this.perspective)).append("\n");
        sb.append("    indicatorCategory: ").append(this.toIndentedString(this.indicatorCategory)).append("\n");
        sb.append("    indicatorType: ").append(this.toIndentedString((Object)this.indicatorType)).append("\n");
        sb.append("    derivationAlgorithm: ").append(this.toIndentedString(this.derivationAlgorithm)).append("\n");
        sb.append("    derivationMethod: ").append(this.toIndentedString(this.derivationMethod)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    collectionType: ").append(this.toIndentedString((Object)this.collectionType)).append("\n");
        sb.append("    indicatorUnit: ").append(this.toIndentedString(this.indicatorUnit)).append("\n");
        sb.append("    performanceIndicatorSpecRelationship: ").append(this.toIndentedString(this.performanceIndicatorSpecRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

