/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.pm628.model.CollectionType;
import org.etsi.osl.tmf.pm628.model.IndicatorType;
import org.etsi.osl.tmf.pm628.model.PatchPerformanceIndicatorSpecification200Response;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecRelationship;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValue;

@Entity(name="PM628_PerfIndSpec")
public class PerformanceIndicatorSpecification
extends BaseRootNamedEntity
implements PatchPerformanceIndicatorSpecification200Response,
PerformanceIndicatorSpecificationRefOrValue {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="perspective")
    private String perspective;
    @JsonProperty(value="indicatorCategory")
    private String indicatorCategory;
    @JsonProperty(value="indicatorType")
    private IndicatorType indicatorType;
    @JsonProperty(value="derivationAlgorithm")
    private String derivationAlgorithm;
    @JsonProperty(value="derivationMethod")
    private String derivationMethod;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;
    @JsonProperty(value="collectionType")
    private CollectionType collectionType;
    @JsonProperty(value="indicatorUnit")
    private String indicatorUnit;
    @JsonProperty(value="performanceIndicatorSpecRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_perf_ind_spec_perf_ind_spec_rel", joinColumns={@JoinColumn(name="perf_ind_spec_uuid")}, inverseJoinColumns={@JoinColumn(name="perf_ind_spec_rel_uuid")})
    private List<PerformanceIndicatorSpecRelationship> performanceIndicatorSpecRelationship = new ArrayList<PerformanceIndicatorSpecRelationship>();

    public PerformanceIndicatorSpecification() {
    }

    public PerformanceIndicatorSpecification(String type) {
        this.type = type;
    }

    public PerformanceIndicatorSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="A narrative that explains in detail what the PerformanceIndicatorSpecification is.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PerformanceIndicatorSpecification perspective(String perspective) {
        this.perspective = perspective;
        return this;
    }

    @Schema(name="perspective", description="The point of view for the PerformanceIndicatorSpecification, such as a single user instance or aggregation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPerspective() {
        return this.perspective;
    }

    public void setPerspective(String perspective) {
        this.perspective = perspective;
    }

    public PerformanceIndicatorSpecification indicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
        return this;
    }

    @Schema(name="indicatorCategory", description="A grouping or set of PerformanceIndicatorSpecifications that are classified together because of common characteristics, such as technology specific, service specific, or technology/service independent.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getIndicatorCategory() {
        return this.indicatorCategory;
    }

    public void setIndicatorCategory(String indicatorCategory) {
        this.indicatorCategory = indicatorCategory;
    }

    public PerformanceIndicatorSpecification indicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    @Valid
    @Schema(name="indicatorType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public IndicatorType getIndicatorType() {
        return this.indicatorType;
    }

    public void setIndicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
    }

    public PerformanceIndicatorSpecification derivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
        return this;
    }

    @Schema(name="derivationAlgorithm", description="A step-by-step procedure used to calculate the value of PerformanceIndicator.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationAlgorithm() {
        return this.derivationAlgorithm;
    }

    public void setDerivationAlgorithm(String derivationAlgorithm) {
        this.derivationAlgorithm = derivationAlgorithm;
    }

    public PerformanceIndicatorSpecification derivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
        return this;
    }

    @Schema(name="derivationMethod", description="For simple calculations, the method used to calculate the value of a PerformanceIndicator, such as average, minimum, maximum, sum and so forth.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public void setDerivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
    }

    public PerformanceIndicatorSpecification validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public PerformanceIndicatorSpecification collectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    @Valid
    @Schema(name="collectionType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public PerformanceIndicatorSpecification indicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
        return this;
    }

    @Schema(name="indicatorUnit", description="The unit by which the indicator is measured. For example, seconds, KBs, rate per second, etc.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getIndicatorUnit() {
        return this.indicatorUnit;
    }

    public void setIndicatorUnit(String indicatorUnit) {
        this.indicatorUnit = indicatorUnit;
    }

    public PerformanceIndicatorSpecification performanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationship> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
        return this;
    }

    public PerformanceIndicatorSpecification addPerformanceIndicatorSpecRelationshipItem(PerformanceIndicatorSpecRelationship performanceIndicatorSpecRelationshipItem) {
        if (this.performanceIndicatorSpecRelationship == null) {
            this.performanceIndicatorSpecRelationship = new ArrayList<PerformanceIndicatorSpecRelationship>();
        }
        this.performanceIndicatorSpecRelationship.add(performanceIndicatorSpecRelationshipItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecRelationship", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorSpecRelationship> getPerformanceIndicatorSpecRelationship() {
        return this.performanceIndicatorSpecRelationship;
    }

    public void setPerformanceIndicatorSpecRelationship(List<PerformanceIndicatorSpecRelationship> performanceIndicatorSpecRelationship) {
        this.performanceIndicatorSpecRelationship = performanceIndicatorSpecRelationship;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceIndicatorSpecification performanceIndicatorSpecification = (PerformanceIndicatorSpecification)o;
        return Objects.equals(this.type, performanceIndicatorSpecification.type) && Objects.equals(this.baseType, performanceIndicatorSpecification.baseType) && Objects.equals(this.schemaLocation, performanceIndicatorSpecification.schemaLocation) && Objects.equals(this.href, performanceIndicatorSpecification.href) && Objects.equals(this.uuid, performanceIndicatorSpecification.uuid) && Objects.equals(this.name, performanceIndicatorSpecification.name) && Objects.equals(this.description, performanceIndicatorSpecification.description) && Objects.equals(this.perspective, performanceIndicatorSpecification.perspective) && Objects.equals(this.indicatorCategory, performanceIndicatorSpecification.indicatorCategory) && Objects.equals((Object)this.indicatorType, (Object)performanceIndicatorSpecification.indicatorType) && Objects.equals(this.derivationAlgorithm, performanceIndicatorSpecification.derivationAlgorithm) && Objects.equals(this.derivationMethod, performanceIndicatorSpecification.derivationMethod) && Objects.equals(this.validFor, performanceIndicatorSpecification.validFor) && Objects.equals((Object)this.collectionType, (Object)performanceIndicatorSpecification.collectionType) && Objects.equals(this.indicatorUnit, performanceIndicatorSpecification.indicatorUnit) && Objects.equals(this.performanceIndicatorSpecRelationship, performanceIndicatorSpecification.performanceIndicatorSpecRelationship);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.description, this.perspective, this.indicatorCategory, this.indicatorType, this.derivationAlgorithm, this.derivationMethod, this.validFor, this.collectionType, this.indicatorUnit, this.performanceIndicatorSpecRelationship});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceIndicatorSpecification {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    perspective: ").append(this.toIndentedString(this.perspective)).append("\n");
        sb.append("    indicatorCategory: ").append(this.toIndentedString(this.indicatorCategory)).append("\n");
        sb.append("    indicatorType: ").append(this.toIndentedString((Object)this.indicatorType)).append("\n");
        sb.append("    derivationAlgorithm: ").append(this.toIndentedString(this.derivationAlgorithm)).append("\n");
        sb.append("    derivationMethod: ").append(this.toIndentedString(this.derivationMethod)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    collectionType: ").append(this.toIndentedString((Object)this.collectionType)).append("\n");
        sb.append("    indicatorUnit: ").append(this.toIndentedString(this.indicatorUnit)).append("\n");
        sb.append("    performanceIndicatorSpecRelationship: ").append(this.toIndentedString(this.performanceIndicatorSpecRelationship)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

