/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm628.model.PatchPerformanceIndicatorGroupSpecification200Response;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecificationRefOrValue;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecification;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRef;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValue;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ManyToAny;

@Entity(name="PM628_PerfIndGroupSpec")
public class PerformanceIndicatorGroupSpecification
extends BaseRootNamedEntity
implements PatchPerformanceIndicatorGroupSpecification200Response,
PerformanceIndicatorGroupSpecificationRefOrValue {
    @JsonProperty(value="groupCategory")
    private String groupCategory;
    @JsonProperty(value="performanceIndicatorSpecification")
    @Valid
    @ManyToAny
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @Column(name="performance_indicator_specification_type")
    @AnyKeyJavaClass(value=String.class)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="value", entity=PerformanceIndicatorSpecification.class), @AnyDiscriminatorValue(discriminator="ref", entity=PerformanceIndicatorSpecificationRef.class)})
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="perf_ind_group_spec_perf_ind_specs", joinColumns={@JoinColumn(name="perf_ind_group_spec_id")}, inverseJoinColumns={@JoinColumn(name="perf_ind_spec_id")})
    private @Valid List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValue>();

    public PerformanceIndicatorGroupSpecification() {
    }

    public PerformanceIndicatorGroupSpecification(String type) {
        this.type = type;
    }

    public PerformanceIndicatorGroupSpecification groupCategory(String groupCategory) {
        this.groupCategory = groupCategory;
        return this;
    }

    @Schema(name="groupCategory", description="A grouping or set of PerformanceIndicatorGroupSpecifications that are classified together because of common characteristics, such as technology specific, service specific, or technology/service independent.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getGroupCategory() {
        return this.groupCategory;
    }

    public void setGroupCategory(String groupCategory) {
        this.groupCategory = groupCategory;
    }

    public PerformanceIndicatorGroupSpecification performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
        return this;
    }

    public PerformanceIndicatorGroupSpecification addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValue performanceIndicatorSpecificationItem) {
        if (this.performanceIndicatorSpecification == null) {
            this.performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValue>();
        }
        this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=1)
    @Schema(name="performanceIndicatorSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=1) List<@Valid PerformanceIndicatorSpecificationRefOrValue> getPerformanceIndicatorSpecification() {
        return this.performanceIndicatorSpecification;
    }

    public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceIndicatorGroupSpecification performanceIndicatorGroupSpecification = (PerformanceIndicatorGroupSpecification)o;
        return Objects.equals(this.type, performanceIndicatorGroupSpecification.type) && Objects.equals(this.baseType, performanceIndicatorGroupSpecification.baseType) && Objects.equals(this.schemaLocation, performanceIndicatorGroupSpecification.schemaLocation) && Objects.equals(this.href, performanceIndicatorGroupSpecification.href) && Objects.equals(this.uuid, performanceIndicatorGroupSpecification.uuid) && Objects.equals(this.name, performanceIndicatorGroupSpecification.name) && Objects.equals(this.groupCategory, performanceIndicatorGroupSpecification.groupCategory) && Objects.equals(this.performanceIndicatorSpecification, performanceIndicatorGroupSpecification.performanceIndicatorSpecification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.groupCategory, this.performanceIndicatorSpecification);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceIndicatorGroupSpecification {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    groupCategory: ").append(this.toIndentedString(this.groupCategory)).append("\n");
        sb.append("    performanceIndicatorSpecification: ").append(this.toIndentedString(this.performanceIndicatorSpecification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

