/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm628.model.PartyRefOrPartyRoleRef;

@Schema(name="PartyRef", description="A Party reference")
@Entity(name="PM628_PartyRef")
public class PartyRef
extends BaseRootNamedEntity
implements PartyRefOrPartyRoleRef {
    @JsonProperty(value="@referredType")
    private String referredType;

    public PartyRef() {
    }

    public PartyRef(String type, String uuid) {
        this.type = type;
        this.uuid = uuid;
    }

    public PartyRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartyRef partyRef = (PartyRef)o;
        return Objects.equals(this.type, partyRef.type) && Objects.equals(this.baseType, partyRef.baseType) && Objects.equals(this.schemaLocation, partyRef.schemaLocation) && Objects.equals(this.href, partyRef.href) && Objects.equals(this.uuid, partyRef.uuid) && Objects.equals(this.name, partyRef.name) && Objects.equals(this.referredType, partyRef.referredType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.name, this.referredType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartyRef {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

