/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

public class NoteFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="author")
    private String author;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime date;
    @JsonProperty(value="text")
    private String text;

    public NoteFVO() {
    }

    public NoteFVO(String type) {
        this.type = type;
    }

    public NoteFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NoteFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public NoteFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public NoteFVO author(String author) {
        this.author = author;
        return this;
    }

    @Schema(name="author", example="Mr. N. Bene", description="Author of the note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public NoteFVO date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Valid
    @Schema(name="date", example="2020-11-20T08:00Z", description="Date of the note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="date")
    public String getDateString() {
        return this.date != null ? this.date.toString() : null;
    }

    public void setDate(String date) {
        if (date != null) {
            this.date = OffsetDateTime.parse(date);
        }
    }

    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public NoteFVO text(String text) {
        this.text = text;
        return this;
    }

    @Schema(name="text", example="This is important", description="Text of the note", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteFVO noteFVO = (NoteFVO)o;
        return Objects.equals(this.type, noteFVO.type) && Objects.equals(this.baseType, noteFVO.baseType) && Objects.equals(this.schemaLocation, noteFVO.schemaLocation) && Objects.equals(this.author, noteFVO.author) && Objects.equals(this.date, noteFVO.date) && Objects.equals(this.text, noteFVO.text);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.author, this.date, this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

