/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.JoinColumn;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.DayOfMonthRecurrence;

@Embeddable
public class MonthlyScheduleDayOfWeekDefinition {
    @JsonProperty(value="@type")
    @Column(name="msdowd_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="msdowd_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="msdowd_schema_location")
    private String schemaLocation;
    @JsonProperty(value="dayOfMonthRecurrence")
    @Valid
    @ElementCollection(targetClass=DayOfMonthRecurrence.class)
    @CollectionTable(name="pm628_sched_def_domr", joinColumns={@JoinColumn(name="sched_def_uuid")})
    private List<DayOfMonthRecurrence> dayOfMonthRecurrence = new ArrayList<DayOfMonthRecurrence>();
    @JsonProperty(value="recurringDaySequence")
    private String recurringDaySequence;

    public MonthlyScheduleDayOfWeekDefinition() {
    }

    public MonthlyScheduleDayOfWeekDefinition(String type) {
        this.type = type;
    }

    public MonthlyScheduleDayOfWeekDefinition type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MonthlyScheduleDayOfWeekDefinition baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public MonthlyScheduleDayOfWeekDefinition schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public MonthlyScheduleDayOfWeekDefinition dayOfMonthRecurrence(List<DayOfMonthRecurrence> dayOfMonthRecurrence) {
        this.dayOfMonthRecurrence = dayOfMonthRecurrence;
        return this;
    }

    public MonthlyScheduleDayOfWeekDefinition addDayOfMonthRecurrenceItem(DayOfMonthRecurrence dayOfMonthRecurrenceItem) {
        if (this.dayOfMonthRecurrence == null) {
            this.dayOfMonthRecurrence = new ArrayList<DayOfMonthRecurrence>();
        }
        this.dayOfMonthRecurrence.add(dayOfMonthRecurrenceItem);
        return this;
    }

    @Valid
    @Schema(name="dayOfMonthRecurrence", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<DayOfMonthRecurrence> getDayOfMonthRecurrence() {
        return this.dayOfMonthRecurrence;
    }

    public void setDayOfMonthRecurrence(List<DayOfMonthRecurrence> dayOfMonthRecurrence) {
        this.dayOfMonthRecurrence = dayOfMonthRecurrence;
    }

    public MonthlyScheduleDayOfWeekDefinition recurringDaySequence(String recurringDaySequence) {
        this.recurringDaySequence = recurringDaySequence;
        return this;
    }

    @Schema(name="recurringDaySequence", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getRecurringDaySequence() {
        return this.recurringDaySequence;
    }

    public void setRecurringDaySequence(String recurringDaySequence) {
        this.recurringDaySequence = recurringDaySequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthlyScheduleDayOfWeekDefinition monthlyScheduleDayOfWeekDefinition = (MonthlyScheduleDayOfWeekDefinition)o;
        return Objects.equals(this.type, monthlyScheduleDayOfWeekDefinition.type) && Objects.equals(this.baseType, monthlyScheduleDayOfWeekDefinition.baseType) && Objects.equals(this.schemaLocation, monthlyScheduleDayOfWeekDefinition.schemaLocation) && Objects.equals(this.dayOfMonthRecurrence, monthlyScheduleDayOfWeekDefinition.dayOfMonthRecurrence) && Objects.equals(this.recurringDaySequence, monthlyScheduleDayOfWeekDefinition.recurringDaySequence);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.dayOfMonthRecurrence, this.recurringDaySequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonthlyScheduleDayOfWeekDefinition {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    dayOfMonthRecurrence: ").append(this.toIndentedString(this.dayOfMonthRecurrence)).append("\n");
        sb.append("    recurringDaySequence: ").append(this.toIndentedString(this.recurringDaySequence)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

