/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Embeddable
public class MonitoredInstancesCriteria {
    @JsonProperty(value="@type")
    @Column(name="mic_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="mic_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="mic_schema_location")
    private String schemaLocation;
    @JsonProperty(value="monitoredObjectInstances")
    @Valid
    private List<String> monitoredObjectInstances = new ArrayList<String>();

    public MonitoredInstancesCriteria() {
    }

    public MonitoredInstancesCriteria(String type) {
        this.type = type;
    }

    public MonitoredInstancesCriteria type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MonitoredInstancesCriteria baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public MonitoredInstancesCriteria schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public MonitoredInstancesCriteria monitoredObjectInstances(List<String> monitoredObjectInstances) {
        this.monitoredObjectInstances = monitoredObjectInstances;
        return this;
    }

    public MonitoredInstancesCriteria addMonitoredObjectInstancesItem(String monitoredObjectInstancesItem) {
        if (this.monitoredObjectInstances == null) {
            this.monitoredObjectInstances = new ArrayList<String>();
        }
        this.monitoredObjectInstances.add(monitoredObjectInstancesItem);
        return this;
    }

    @Size(min=0)
    @Schema(name="monitoredObjectInstances", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Size(min=0) List<String> getMonitoredObjectInstances() {
        return this.monitoredObjectInstances;
    }

    public void setMonitoredObjectInstances(List<String> monitoredObjectInstances) {
        this.monitoredObjectInstances = monitoredObjectInstances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoredInstancesCriteria monitoredInstancesCriteria = (MonitoredInstancesCriteria)o;
        return Objects.equals(this.type, monitoredInstancesCriteria.type) && Objects.equals(this.baseType, monitoredInstancesCriteria.baseType) && Objects.equals(this.schemaLocation, monitoredInstancesCriteria.schemaLocation) && Objects.equals(this.monitoredObjectInstances, monitoredInstancesCriteria.monitoredObjectInstances);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.monitoredObjectInstances);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitoredInstancesCriteria {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    monitoredObjectInstances: ").append(this.toIndentedString(this.monitoredObjectInstances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

