/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Embeddable
public class MonitoredClassCriteria {
    @JsonProperty(value="@type")
    @Column(name="mcc_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="mcc_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="mcc_schema_location")
    private String schemaLocation;
    @JsonProperty(value="monitoredObjectClass")
    private String monitoredObjectClass;
    @JsonProperty(value="objectInstanceFilter")
    private String objectInstanceFilter;

    public MonitoredClassCriteria() {
    }

    public MonitoredClassCriteria(String type) {
        this.type = type;
    }

    public MonitoredClassCriteria type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MonitoredClassCriteria baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public MonitoredClassCriteria schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public MonitoredClassCriteria monitoredObjectClass(String monitoredObjectClass) {
        this.monitoredObjectClass = monitoredObjectClass;
        return this;
    }

    @Schema(name="monitoredObjectClass", description="A monitored object class for specifying the set of instances that are referenced by a PM query.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getMonitoredObjectClass() {
        return this.monitoredObjectClass;
    }

    public void setMonitoredObjectClass(String monitoredObjectClass) {
        this.monitoredObjectClass = monitoredObjectClass;
    }

    public MonitoredClassCriteria objectInstanceFilter(String objectInstanceFilter) {
        this.objectInstanceFilter = objectInstanceFilter;
        return this;
    }

    @Schema(name="objectInstanceFilter", description="A filter that can be used in conjunction with the monitored object class for specifying the set of instances that are referenced by a PM query.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getObjectInstanceFilter() {
        return this.objectInstanceFilter;
    }

    public void setObjectInstanceFilter(String objectInstanceFilter) {
        this.objectInstanceFilter = objectInstanceFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoredClassCriteria monitoredClassCriteria = (MonitoredClassCriteria)o;
        return Objects.equals(this.type, monitoredClassCriteria.type) && Objects.equals(this.baseType, monitoredClassCriteria.baseType) && Objects.equals(this.schemaLocation, monitoredClassCriteria.schemaLocation) && Objects.equals(this.monitoredObjectClass, monitoredClassCriteria.monitoredObjectClass) && Objects.equals(this.objectInstanceFilter, monitoredClassCriteria.objectInstanceFilter);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.monitoredObjectClass, this.objectInstanceFilter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitoredClassCriteria {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    monitoredObjectClass: ").append(this.toIndentedString(this.monitoredObjectClass)).append("\n");
        sb.append("    objectInstanceFilter: ").append(this.toIndentedString(this.objectInstanceFilter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

