/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointMVO;
import org.etsi.osl.tmf.pm628.model.FileTransferDataMVO;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.ManagementJobMVO;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobMVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecificationMVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValueMVO;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionMVO;
import org.etsi.osl.tmf.pm628.model.TrackingRecordMVO;

@JsonIgnoreProperties(ignoreUnknown=true, value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MeasurementCollectionJobMVO.class, name="MeasurementCollectionJob")})
public class MeasurementJobMVO
extends ManagementJobMVO {
    @JsonProperty(value="consumingApplicationId")
    private String consumingApplicationId;
    @JsonProperty(value="producingApplicationId")
    private String producingApplicationId;
    @JsonProperty(value="granularity")
    private Granularity granularity;
    @JsonProperty(value="performanceIndicatorGroupSpecification")
    @Valid
    private List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification;
    @JsonProperty(value="performanceIndicatorSpecification")
    @Valid
    private @Valid List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification;
    @JsonProperty(value="trackingRecord")
    @Valid
    private List<TrackingRecordMVO> trackingRecord;

    public MeasurementJobMVO() {
    }

    public MeasurementJobMVO(String atType) {
        super(atType);
    }

    public MeasurementJobMVO consumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
        return this;
    }

    @Schema(name="consumingApplicationId", description="The identifier of the application that consumes performance indicators.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getConsumingApplicationId() {
        return this.consumingApplicationId;
    }

    public void setConsumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
    }

    public MeasurementJobMVO producingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
        return this;
    }

    @Schema(name="producingApplicationId", description="The identifier of the application that produces performance indicators.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getProducingApplicationId() {
        return this.producingApplicationId;
    }

    public void setProducingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
    }

    public MeasurementJobMVO granularity(Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    @Valid
    @Schema(name="granularity", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    public MeasurementJobMVO performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
        return this;
    }

    public MeasurementJobMVO addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecificationMVO performanceIndicatorGroupSpecificationItem) {
        if (this.performanceIndicatorGroupSpecification == null) {
            this.performanceIndicatorGroupSpecification = new ArrayList<PerformanceIndicatorGroupSpecificationMVO>();
        }
        this.performanceIndicatorGroupSpecification.add(performanceIndicatorGroupSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorGroupSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorGroupSpecificationMVO> getPerformanceIndicatorGroupSpecification() {
        return this.performanceIndicatorGroupSpecification;
    }

    public void setPerformanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationMVO> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
    }

    public MeasurementJobMVO performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
        return this;
    }

    public MeasurementJobMVO addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValueMVO performanceIndicatorSpecificationItem) {
        if (this.performanceIndicatorSpecification == null) {
            this.performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValueMVO>();
        }
        this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> getPerformanceIndicatorSpecification() {
        return this.performanceIndicatorSpecification;
    }

    public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueMVO> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    }

    public MeasurementJobMVO trackingRecord(List<TrackingRecordMVO> trackingRecord) {
        this.trackingRecord = trackingRecord;
        return this;
    }

    public MeasurementJobMVO addTrackingRecordItem(TrackingRecordMVO trackingRecordItem) {
        if (this.trackingRecord == null) {
            this.trackingRecord = new ArrayList<TrackingRecordMVO>();
        }
        this.trackingRecord.add(trackingRecordItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="trackingRecord", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<TrackingRecordMVO> getTrackingRecord() {
        return this.trackingRecord;
    }

    public void setTrackingRecord(List<TrackingRecordMVO> trackingRecord) {
        this.trackingRecord = trackingRecord;
    }

    @Override
    public MeasurementJobMVO fileTransferData(List<FileTransferDataMVO> fileTransferData) {
        super.fileTransferData(fileTransferData);
        return this;
    }

    @Override
    public MeasurementJobMVO addFileTransferDataItem(FileTransferDataMVO fileTransferDataItem) {
        super.addFileTransferDataItem(fileTransferDataItem);
        return this;
    }

    @Override
    public MeasurementJobMVO dataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
        super.dataAccessEndpoint(dataAccessEndpoint);
        return this;
    }

    @Override
    public MeasurementJobMVO addDataAccessEndpointItem(DataAccessEndpointMVO dataAccessEndpointItem) {
        super.addDataAccessEndpointItem(dataAccessEndpointItem);
        return this;
    }

    @Override
    public MeasurementJobMVO scheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
        super.scheduleDefinition(scheduleDefinition);
        return this;
    }

    @Override
    public MeasurementJobMVO addScheduleDefinitionItem(ScheduleDefinitionMVO scheduleDefinitionItem) {
        super.addScheduleDefinitionItem(scheduleDefinitionItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementJobMVO measurementJobMVO = (MeasurementJobMVO)o;
        return Objects.equals(this.consumingApplicationId, measurementJobMVO.consumingApplicationId) && Objects.equals(this.producingApplicationId, measurementJobMVO.producingApplicationId) && Objects.equals((Object)this.granularity, (Object)measurementJobMVO.granularity) && Objects.equals(this.performanceIndicatorGroupSpecification, measurementJobMVO.performanceIndicatorGroupSpecification) && Objects.equals(this.performanceIndicatorSpecification, measurementJobMVO.performanceIndicatorSpecification) && Objects.equals(this.trackingRecord, measurementJobMVO.trackingRecord) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.consumingApplicationId, this.producingApplicationId, this.granularity, this.performanceIndicatorGroupSpecification, this.performanceIndicatorSpecification, this.trackingRecord, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasurementJobMVO {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    consumingApplicationId: ").append(this.toIndentedString(this.consumingApplicationId)).append("\n");
        sb.append("    producingApplicationId: ").append(this.toIndentedString(this.producingApplicationId)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    performanceIndicatorGroupSpecification: ").append(this.toIndentedString(this.performanceIndicatorGroupSpecification)).append("\n");
        sb.append("    performanceIndicatorSpecification: ").append(this.toIndentedString(this.performanceIndicatorSpecification)).append("\n");
        sb.append("    trackingRecord: ").append(this.toIndentedString(this.trackingRecord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

