/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointFVO;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferDataFVO;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.ManagementJobFVO;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobFVO;
import org.etsi.osl.tmf.pm628.model.MonitoredClassCriteriaFVO;
import org.etsi.osl.tmf.pm628.model.MonitoredInstancesCriteriaFVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecificationFVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValueFVO;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionFVO;
import org.etsi.osl.tmf.pm628.model.TrackingRecordFVO;

@JsonIgnoreProperties(ignoreUnknown=true, value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MeasurementCollectionJobFVO.class, name="MeasurementCollectionJob")})
public class MeasurementJobFVO
extends ManagementJobFVO {
    @JsonProperty(value="consumingApplicationId")
    private String consumingApplicationId;
    @JsonProperty(value="producingApplicationId")
    private String producingApplicationId;
    @JsonProperty(value="granularity")
    private Granularity granularity;
    @JsonProperty(value="performanceIndicatorGroupSpecification")
    @Valid
    private List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification = new ArrayList<PerformanceIndicatorGroupSpecificationFVO>();
    @JsonProperty(value="performanceIndicatorSpecification")
    @Valid
    private @Valid List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValueFVO>();
    @JsonProperty(value="trackingRecord")
    @Valid
    private List<TrackingRecordFVO> trackingRecord = new ArrayList<TrackingRecordFVO>();
    @JsonProperty(value="monitoredInstancesCriteria")
    private MonitoredInstancesCriteriaFVO monitoredInstancesCriteria;
    @JsonProperty(value="monitoredClassCriteria")
    private MonitoredClassCriteriaFVO monitoredClassCriteria;

    public MeasurementJobFVO() {
    }

    public MeasurementJobFVO(String consumingApplicationId, String producingApplicationId, List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification, String atType) {
        super(atType);
        this.consumingApplicationId = consumingApplicationId;
        this.producingApplicationId = producingApplicationId;
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    }

    public MeasurementJobFVO consumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
        return this;
    }

    @NotNull
    @Schema(name="consumingApplicationId", description="The identifier of the application that consumes performance indicators.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getConsumingApplicationId() {
        return this.consumingApplicationId;
    }

    public void setConsumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
    }

    public MeasurementJobFVO producingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
        return this;
    }

    @NotNull
    @Schema(name="producingApplicationId", description="The identifier of the application that produces performance indicators.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getProducingApplicationId() {
        return this.producingApplicationId;
    }

    public void setProducingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
    }

    public MeasurementJobFVO granularity(Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    @Valid
    @Schema(name="granularity", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    public MeasurementJobFVO performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
        return this;
    }

    public MeasurementJobFVO addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecificationFVO performanceIndicatorGroupSpecificationItem) {
        if (this.performanceIndicatorGroupSpecification == null) {
            this.performanceIndicatorGroupSpecification = new ArrayList<PerformanceIndicatorGroupSpecificationFVO>();
        }
        this.performanceIndicatorGroupSpecification.add(performanceIndicatorGroupSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorGroupSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorGroupSpecificationFVO> getPerformanceIndicatorGroupSpecification() {
        return this.performanceIndicatorGroupSpecification;
    }

    public void setPerformanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
    }

    public MeasurementJobFVO performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
        return this;
    }

    public MeasurementJobFVO addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValueFVO performanceIndicatorSpecificationItem) {
        if (this.performanceIndicatorSpecification == null) {
            this.performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValueFVO>();
        }
        this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecification", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Valid @Size(min=0) List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> getPerformanceIndicatorSpecification() {
        return this.performanceIndicatorSpecification;
    }

    public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    }

    public MeasurementJobFVO trackingRecord(List<TrackingRecordFVO> trackingRecord) {
        this.trackingRecord = trackingRecord;
        return this;
    }

    public MeasurementJobFVO addTrackingRecordItem(TrackingRecordFVO trackingRecordItem) {
        if (this.trackingRecord == null) {
            this.trackingRecord = new ArrayList<TrackingRecordFVO>();
        }
        this.trackingRecord.add(trackingRecordItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="trackingRecord", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<TrackingRecordFVO> getTrackingRecord() {
        return this.trackingRecord;
    }

    public void setTrackingRecord(List<TrackingRecordFVO> trackingRecord) {
        this.trackingRecord = trackingRecord;
    }

    public MeasurementJobFVO monitoredInstancesCriteria(MonitoredInstancesCriteriaFVO monitoredInstancesCriteria) {
        this.monitoredInstancesCriteria = monitoredInstancesCriteria;
        return this;
    }

    @Valid
    @Schema(name="monitoredInstancesCriteria", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonitoredInstancesCriteriaFVO getMonitoredInstancesCriteria() {
        return this.monitoredInstancesCriteria;
    }

    public void setMonitoredInstancesCriteria(MonitoredInstancesCriteriaFVO monitoredInstancesCriteria) {
        this.monitoredInstancesCriteria = monitoredInstancesCriteria;
    }

    public MeasurementJobFVO monitoredClassCriteria(MonitoredClassCriteriaFVO monitoredClassCriteria) {
        this.monitoredClassCriteria = monitoredClassCriteria;
        return this;
    }

    @Valid
    @Schema(name="monitoredClassCriteria", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonitoredClassCriteriaFVO getMonitoredClassCriteria() {
        return this.monitoredClassCriteria;
    }

    public void setMonitoredClassCriteria(MonitoredClassCriteriaFVO monitoredClassCriteria) {
        this.monitoredClassCriteria = monitoredClassCriteria;
    }

    @Override
    public MeasurementJobFVO adminState(AdministrativeState adminState) {
        super.adminState(adminState);
        return this;
    }

    @Override
    public MeasurementJobFVO creationTime(OffsetDateTime creationTime) {
        super.creationTime(creationTime);
        return this;
    }

    @Override
    public MeasurementJobFVO executionState(ExecutionStateType executionState) {
        super.executionState(executionState);
        return this;
    }

    @Override
    public MeasurementJobFVO fileTransferData(List<FileTransferDataFVO> fileTransferData) {
        super.fileTransferData(fileTransferData);
        return this;
    }

    @Override
    public MeasurementJobFVO addFileTransferDataItem(FileTransferDataFVO fileTransferDataItem) {
        super.addFileTransferDataItem(fileTransferDataItem);
        return this;
    }

    @Override
    public MeasurementJobFVO dataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
        super.dataAccessEndpoint(dataAccessEndpoint);
        return this;
    }

    @Override
    public MeasurementJobFVO addDataAccessEndpointItem(DataAccessEndpointFVO dataAccessEndpointItem) {
        super.addDataAccessEndpointItem(dataAccessEndpointItem);
        return this;
    }

    @Override
    public MeasurementJobFVO jobId(String jobId) {
        super.jobId(jobId);
        return this;
    }

    @Override
    public MeasurementJobFVO jobPriority(Integer jobPriority) {
        super.jobPriority(jobPriority);
        return this;
    }

    @Override
    public MeasurementJobFVO lastModifiedTime(OffsetDateTime lastModifiedTime) {
        super.lastModifiedTime(lastModifiedTime);
        return this;
    }

    @Override
    public MeasurementJobFVO scheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
        super.scheduleDefinition(scheduleDefinition);
        return this;
    }

    @Override
    public MeasurementJobFVO addScheduleDefinitionItem(ScheduleDefinitionFVO scheduleDefinitionItem) {
        super.addScheduleDefinitionItem(scheduleDefinitionItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementJobFVO measurementJobFVO = (MeasurementJobFVO)o;
        return Objects.equals(this.consumingApplicationId, measurementJobFVO.consumingApplicationId) && Objects.equals(this.producingApplicationId, measurementJobFVO.producingApplicationId) && Objects.equals((Object)this.granularity, (Object)measurementJobFVO.granularity) && Objects.equals(this.performanceIndicatorGroupSpecification, measurementJobFVO.performanceIndicatorGroupSpecification) && Objects.equals(this.performanceIndicatorSpecification, measurementJobFVO.performanceIndicatorSpecification) && Objects.equals(this.trackingRecord, measurementJobFVO.trackingRecord) && Objects.equals(this.monitoredInstancesCriteria, measurementJobFVO.monitoredInstancesCriteria) && Objects.equals(this.monitoredClassCriteria, measurementJobFVO.monitoredClassCriteria) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.consumingApplicationId, this.producingApplicationId, this.granularity, this.performanceIndicatorGroupSpecification, this.performanceIndicatorSpecification, this.trackingRecord, this.monitoredInstancesCriteria, this.monitoredClassCriteria, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasurementJobFVO {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    consumingApplicationId: ").append(this.toIndentedString(this.consumingApplicationId)).append("\n");
        sb.append("    producingApplicationId: ").append(this.toIndentedString(this.producingApplicationId)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    performanceIndicatorGroupSpecification: ").append(this.toIndentedString(this.performanceIndicatorGroupSpecification)).append("\n");
        sb.append("    performanceIndicatorSpecification: ").append(this.toIndentedString(this.performanceIndicatorSpecification)).append("\n");
        sb.append("    trackingRecord: ").append(this.toIndentedString(this.trackingRecord)).append("\n");
        sb.append("    monitoredInstancesCriteria: ").append(this.toIndentedString(this.monitoredInstancesCriteria)).append("\n");
        sb.append("    monitoredClassCriteria: ").append(this.toIndentedString(this.monitoredClassCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

