/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferData;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.ManagementJob;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MonitoredClassCriteria;
import org.etsi.osl.tmf.pm628.model.MonitoredInstancesCriteria;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecification;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecification;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRef;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValue;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinition;
import org.etsi.osl.tmf.pm628.model.TrackingRecord;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ManyToAny;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MeasurementCollectionJob.class, name="MeasurementCollectionJob")})
@Entity(name="PM628_MeasJob")
public class MeasurementJob
extends ManagementJob {
    @JsonProperty(value="consumingApplicationId")
    private String consumingApplicationId;
    @JsonProperty(value="producingApplicationId")
    private String producingApplicationId;
    @JsonProperty(value="granularity")
    private Granularity granularity;
    @JsonProperty(value="performanceIndicatorGroupSpecification")
    @Valid
    @ManyToMany(cascade={jakarta.persistence.CascadeType.MERGE, jakarta.persistence.CascadeType.PERSIST, jakarta.persistence.CascadeType.REFRESH})
    @JoinTable(name="pm628_meas_job_perf_ind_group_spec", joinColumns={@JoinColumn(name="meas_job_uuid")}, inverseJoinColumns={@JoinColumn(name="perf_ind_group_spec_uuid")})
    private List<PerformanceIndicatorGroupSpecification> performanceIndicatorGroupSpecification = new ArrayList<PerformanceIndicatorGroupSpecification>();
    @JsonProperty(value="performanceIndicatorSpecification")
    @Valid
    @ManyToAny
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @Column(name="perf_ind_spec_type")
    @AnyKeyJavaClass(value=String.class)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="value", entity=PerformanceIndicatorSpecification.class), @AnyDiscriminatorValue(discriminator="ref", entity=PerformanceIndicatorSpecificationRef.class)})
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="pm628_meas_job_perf_ind_specs", joinColumns={@JoinColumn(name="meas_job_uuid")}, inverseJoinColumns={@JoinColumn(name="perf_ind_spec_uuid")})
    private @Valid List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValue>();
    @JsonProperty(value="trackingRecord")
    @Valid
    @OneToMany(cascade={jakarta.persistence.CascadeType.MERGE, jakarta.persistence.CascadeType.PERSIST, jakarta.persistence.CascadeType.REFRESH})
    @JoinTable(name="pm628_meas_job_track_rec", joinColumns={@JoinColumn(name="meas_job_uuid")}, inverseJoinColumns={@JoinColumn(name="track_rec_uuid")})
    private List<TrackingRecord> trackingRecord = new ArrayList<TrackingRecord>();
    @JsonProperty(value="monitoredInstancesCriteria")
    @Embedded
    private MonitoredInstancesCriteria monitoredInstancesCriteria;
    @JsonProperty(value="monitoredClassCriteria")
    @Embedded
    private MonitoredClassCriteria monitoredClassCriteria;

    public MeasurementJob() {
    }

    public MeasurementJob(String atType) {
        super(atType);
    }

    public MeasurementJob consumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
        return this;
    }

    @Schema(name="consumingApplicationId", description="The identifier of the application that consumes performance indicators.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getConsumingApplicationId() {
        return this.consumingApplicationId;
    }

    public void setConsumingApplicationId(String consumingApplicationId) {
        this.consumingApplicationId = consumingApplicationId;
    }

    public MeasurementJob producingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
        return this;
    }

    @Schema(name="producingApplicationId", description="The identifier of the application that produces performance indicators.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getProducingApplicationId() {
        return this.producingApplicationId;
    }

    public void setProducingApplicationId(String producingApplicationId) {
        this.producingApplicationId = producingApplicationId;
    }

    public MeasurementJob granularity(Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    @Valid
    @Schema(name="granularity", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    public MeasurementJob performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecification> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
        return this;
    }

    public MeasurementJob addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecification performanceIndicatorGroupSpecificationItem) {
        if (this.performanceIndicatorGroupSpecification == null) {
            this.performanceIndicatorGroupSpecification = new ArrayList<PerformanceIndicatorGroupSpecification>();
        }
        this.performanceIndicatorGroupSpecification.add(performanceIndicatorGroupSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorGroupSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<PerformanceIndicatorGroupSpecification> getPerformanceIndicatorGroupSpecification() {
        return this.performanceIndicatorGroupSpecification;
    }

    public void setPerformanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecification> performanceIndicatorGroupSpecification) {
        this.performanceIndicatorGroupSpecification = performanceIndicatorGroupSpecification;
    }

    public MeasurementJob performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
        return this;
    }

    public MeasurementJob addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValue performanceIndicatorSpecificationItem) {
        if (this.performanceIndicatorSpecification == null) {
            this.performanceIndicatorSpecification = new ArrayList<PerformanceIndicatorSpecificationRefOrValue>();
        }
        this.performanceIndicatorSpecification.add(performanceIndicatorSpecificationItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="performanceIndicatorSpecification", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<@Valid PerformanceIndicatorSpecificationRefOrValue> getPerformanceIndicatorSpecification() {
        return this.performanceIndicatorSpecification;
    }

    public void setPerformanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification) {
        this.performanceIndicatorSpecification = performanceIndicatorSpecification;
    }

    public MeasurementJob trackingRecord(List<TrackingRecord> trackingRecord) {
        this.trackingRecord = trackingRecord;
        return this;
    }

    public MeasurementJob addTrackingRecordItem(TrackingRecord trackingRecordItem) {
        if (this.trackingRecord == null) {
            this.trackingRecord = new ArrayList<TrackingRecord>();
        }
        this.trackingRecord.add(trackingRecordItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="trackingRecord", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<TrackingRecord> getTrackingRecord() {
        return this.trackingRecord;
    }

    public void setTrackingRecord(List<TrackingRecord> trackingRecord) {
        this.trackingRecord = trackingRecord;
    }

    public MeasurementJob monitoredInstancesCriteria(MonitoredInstancesCriteria monitoredInstancesCriteria) {
        this.monitoredInstancesCriteria = monitoredInstancesCriteria;
        return this;
    }

    @Valid
    @Schema(name="monitoredInstancesCriteria", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonitoredInstancesCriteria getMonitoredInstancesCriteria() {
        return this.monitoredInstancesCriteria;
    }

    public void setMonitoredInstancesCriteria(MonitoredInstancesCriteria monitoredInstancesCriteria) {
        this.monitoredInstancesCriteria = monitoredInstancesCriteria;
    }

    public MeasurementJob monitoredClassCriteria(MonitoredClassCriteria monitoredClassCriteria) {
        this.monitoredClassCriteria = monitoredClassCriteria;
        return this;
    }

    @Valid
    @Schema(name="monitoredClassCriteria", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public MonitoredClassCriteria getMonitoredClassCriteria() {
        return this.monitoredClassCriteria;
    }

    public void setMonitoredClassCriteria(MonitoredClassCriteria monitoredClassCriteria) {
        this.monitoredClassCriteria = monitoredClassCriteria;
    }

    @Override
    public MeasurementJob adminState(AdministrativeState adminState) {
        super.adminState(adminState);
        return this;
    }

    @Override
    public MeasurementJob creationTime(OffsetDateTime creationTime) {
        super.creationTime(creationTime);
        return this;
    }

    @Override
    public MeasurementJob executionState(ExecutionStateType executionState) {
        super.executionState(executionState);
        return this;
    }

    @Override
    public MeasurementJob fileTransferData(List<FileTransferData> fileTransferData) {
        super.fileTransferData(fileTransferData);
        return this;
    }

    @Override
    public MeasurementJob addFileTransferDataItem(FileTransferData fileTransferDataItem) {
        super.addFileTransferDataItem(fileTransferDataItem);
        return this;
    }

    @Override
    public MeasurementJob dataAccessEndpoint(List<DataAccessEndpoint> dataAccessEndpoint) {
        super.dataAccessEndpoint(dataAccessEndpoint);
        return this;
    }

    @Override
    public MeasurementJob addDataAccessEndpointItem(DataAccessEndpoint dataAccessEndpointItem) {
        super.addDataAccessEndpointItem(dataAccessEndpointItem);
        return this;
    }

    @Override
    public MeasurementJob jobId(String jobId) {
        super.jobId(jobId);
        return this;
    }

    @Override
    public MeasurementJob jobPriority(Integer jobPriority) {
        super.jobPriority(jobPriority);
        return this;
    }

    @Override
    public MeasurementJob lastModifiedTime(OffsetDateTime lastModifiedTime) {
        super.lastModifiedTime(lastModifiedTime);
        return this;
    }

    @Override
    public MeasurementJob scheduleDefinition(List<ScheduleDefinition> scheduleDefinition) {
        super.scheduleDefinition(scheduleDefinition);
        return this;
    }

    @Override
    public MeasurementJob addScheduleDefinitionItem(ScheduleDefinition scheduleDefinitionItem) {
        super.addScheduleDefinitionItem(scheduleDefinitionItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementJob measurementJob = (MeasurementJob)o;
        return Objects.equals(this.consumingApplicationId, measurementJob.consumingApplicationId) && Objects.equals(this.producingApplicationId, measurementJob.producingApplicationId) && Objects.equals((Object)this.granularity, (Object)measurementJob.granularity) && Objects.equals(this.performanceIndicatorGroupSpecification, measurementJob.performanceIndicatorGroupSpecification) && Objects.equals(this.performanceIndicatorSpecification, measurementJob.performanceIndicatorSpecification) && Objects.equals(this.trackingRecord, measurementJob.trackingRecord) && Objects.equals(this.monitoredInstancesCriteria, measurementJob.monitoredInstancesCriteria) && Objects.equals(this.monitoredClassCriteria, measurementJob.monitoredClassCriteria) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.consumingApplicationId, this.producingApplicationId, this.granularity, this.performanceIndicatorGroupSpecification, this.performanceIndicatorSpecification, this.trackingRecord, this.monitoredInstancesCriteria, this.monitoredClassCriteria, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasurementJob {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    consumingApplicationId: ").append(this.toIndentedString(this.consumingApplicationId)).append("\n");
        sb.append("    producingApplicationId: ").append(this.toIndentedString(this.producingApplicationId)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    performanceIndicatorGroupSpecification: ").append(this.toIndentedString(this.performanceIndicatorGroupSpecification)).append("\n");
        sb.append("    performanceIndicatorSpecification: ").append(this.toIndentedString(this.performanceIndicatorSpecification)).append("\n");
        sb.append("    trackingRecord: ").append(this.toIndentedString(this.trackingRecord)).append("\n");
        sb.append("    monitoredInstancesCriteria: ").append(this.toIndentedString(this.monitoredInstancesCriteria)).append("\n");
        sb.append("    monitoredClassCriteria: ").append(this.toIndentedString(this.monitoredClassCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

