/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointFVO;
import org.etsi.osl.tmf.pm628.model.DataFilterMapFVO;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferDataFVO;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.MeasurementJobFVO;
import org.etsi.osl.tmf.pm628.model.MonitoredClassCriteriaFVO;
import org.etsi.osl.tmf.pm628.model.MonitoredInstancesCriteriaFVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecificationFVO;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValueFVO;
import org.etsi.osl.tmf.pm628.model.ReportingPeriod;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionFVO;
import org.etsi.osl.tmf.pm628.model.TrackingRecordFVO;

public class MeasurementCollectionJobFVO
extends MeasurementJobFVO {
    @JsonProperty(value="outputFormat")
    private String outputFormat;
    @JsonProperty(value="reportingPeriod")
    private ReportingPeriod reportingPeriod;
    @JsonProperty(value="jobCollectionFilter")
    private DataFilterMapFVO jobCollectionFilter;
    @JsonProperty(value="searchTaskFilter")
    private DataFilterMapFVO searchTaskFilter;
    @JsonProperty(value="jobOnDemand")
    private Boolean jobOnDemand = false;

    public MeasurementCollectionJobFVO() {
    }

    public MeasurementCollectionJobFVO(String atType, String consumingApplicationId, String producingApplicationId, List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
        super(consumingApplicationId, producingApplicationId, performanceIndicatorSpecification, atType);
    }

    public MeasurementCollectionJobFVO outputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Schema(name="outputFormat", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public MeasurementCollectionJobFVO reportingPeriod(ReportingPeriod reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
        return this;
    }

    @Valid
    @Schema(name="reportingPeriod", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ReportingPeriod getReportingPeriod() {
        return this.reportingPeriod;
    }

    public void setReportingPeriod(ReportingPeriod reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
    }

    public MeasurementCollectionJobFVO jobCollectionFilter(DataFilterMapFVO jobCollectionFilter) {
        this.jobCollectionFilter = jobCollectionFilter;
        return this;
    }

    @Valid
    @Schema(name="jobCollectionFilter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public DataFilterMapFVO getJobCollectionFilter() {
        return this.jobCollectionFilter;
    }

    public void setJobCollectionFilter(DataFilterMapFVO jobCollectionFilter) {
        this.jobCollectionFilter = jobCollectionFilter;
    }

    public MeasurementCollectionJobFVO searchTaskFilter(DataFilterMapFVO searchTaskFilter) {
        this.searchTaskFilter = searchTaskFilter;
        return this;
    }

    @Valid
    @Schema(name="searchTaskFilter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public DataFilterMapFVO getSearchTaskFilter() {
        return this.searchTaskFilter;
    }

    public void setSearchTaskFilter(DataFilterMapFVO searchTaskFilter) {
        this.searchTaskFilter = searchTaskFilter;
    }

    public MeasurementCollectionJobFVO jobOnDemand(Boolean jobOnDemand) {
        this.jobOnDemand = jobOnDemand;
        return this;
    }

    @Schema(name="jobOnDemand", description="True if the job is a single job to be executed immediately in which case the reportingPeriod and scheduleDefinition would not be applicable, false otherwise", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getJobOnDemand() {
        return this.jobOnDemand;
    }

    public void setJobOnDemand(Boolean jobOnDemand) {
        this.jobOnDemand = jobOnDemand;
    }

    @Override
    public MeasurementCollectionJobFVO consumingApplicationId(String consumingApplicationId) {
        super.consumingApplicationId(consumingApplicationId);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO producingApplicationId(String producingApplicationId) {
        super.producingApplicationId(producingApplicationId);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO granularity(Granularity granularity) {
        super.granularity(granularity);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecificationFVO> performanceIndicatorGroupSpecification) {
        super.performanceIndicatorGroupSpecification(performanceIndicatorGroupSpecification);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecificationFVO performanceIndicatorGroupSpecificationItem) {
        super.addPerformanceIndicatorGroupSpecificationItem(performanceIndicatorGroupSpecificationItem);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValueFVO> performanceIndicatorSpecification) {
        super.performanceIndicatorSpecification(performanceIndicatorSpecification);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValueFVO performanceIndicatorSpecificationItem) {
        super.addPerformanceIndicatorSpecificationItem(performanceIndicatorSpecificationItem);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO trackingRecord(List<TrackingRecordFVO> trackingRecord) {
        super.trackingRecord(trackingRecord);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addTrackingRecordItem(TrackingRecordFVO trackingRecordItem) {
        super.addTrackingRecordItem(trackingRecordItem);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO monitoredInstancesCriteria(MonitoredInstancesCriteriaFVO monitoredInstancesCriteria) {
        super.monitoredInstancesCriteria(monitoredInstancesCriteria);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO monitoredClassCriteria(MonitoredClassCriteriaFVO monitoredClassCriteria) {
        super.monitoredClassCriteria(monitoredClassCriteria);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO adminState(AdministrativeState adminState) {
        super.adminState(adminState);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO creationTime(OffsetDateTime creationTime) {
        super.creationTime(creationTime);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO executionState(ExecutionStateType executionState) {
        super.executionState(executionState);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO fileTransferData(List<FileTransferDataFVO> fileTransferData) {
        super.fileTransferData((List)fileTransferData);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addFileTransferDataItem(FileTransferDataFVO fileTransferDataItem) {
        super.addFileTransferDataItem(fileTransferDataItem);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO dataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
        super.dataAccessEndpoint((List)dataAccessEndpoint);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addDataAccessEndpointItem(DataAccessEndpointFVO dataAccessEndpointItem) {
        super.addDataAccessEndpointItem(dataAccessEndpointItem);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO jobId(String jobId) {
        super.jobId(jobId);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO jobPriority(Integer jobPriority) {
        super.jobPriority(jobPriority);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO lastModifiedTime(OffsetDateTime lastModifiedTime) {
        super.lastModifiedTime(lastModifiedTime);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO scheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
        super.scheduleDefinition((List)scheduleDefinition);
        return this;
    }

    @Override
    public MeasurementCollectionJobFVO addScheduleDefinitionItem(ScheduleDefinitionFVO scheduleDefinitionItem) {
        super.addScheduleDefinitionItem(scheduleDefinitionItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementCollectionJobFVO measurementCollectionJobFVO = (MeasurementCollectionJobFVO)o;
        return Objects.equals(this.outputFormat, measurementCollectionJobFVO.outputFormat) && Objects.equals((Object)this.reportingPeriod, (Object)measurementCollectionJobFVO.reportingPeriod) && Objects.equals(this.jobCollectionFilter, measurementCollectionJobFVO.jobCollectionFilter) && Objects.equals(this.searchTaskFilter, measurementCollectionJobFVO.searchTaskFilter) && Objects.equals(this.jobOnDemand, measurementCollectionJobFVO.jobOnDemand) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.outputFormat, this.reportingPeriod, this.jobCollectionFilter, this.searchTaskFilter, this.jobOnDemand, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasurementCollectionJobFVO {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString(this.outputFormat)).append("\n");
        sb.append("    reportingPeriod: ").append(this.toIndentedString((Object)this.reportingPeriod)).append("\n");
        sb.append("    jobCollectionFilter: ").append(this.toIndentedString(this.jobCollectionFilter)).append("\n");
        sb.append("    searchTaskFilter: ").append(this.toIndentedString(this.searchTaskFilter)).append("\n");
        sb.append("    jobOnDemand: ").append(this.toIndentedString(this.jobOnDemand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

