/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.DataFilterMap;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferData;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.MeasurementJob;
import org.etsi.osl.tmf.pm628.model.MonitoredClassCriteria;
import org.etsi.osl.tmf.pm628.model.MonitoredInstancesCriteria;
import org.etsi.osl.tmf.pm628.model.PatchMeasurementCollectionJob200Response;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorGroupSpecification;
import org.etsi.osl.tmf.pm628.model.PerformanceIndicatorSpecificationRefOrValue;
import org.etsi.osl.tmf.pm628.model.ReportingPeriod;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinition;
import org.etsi.osl.tmf.pm628.model.TrackingRecord;

@Entity(name="PM628_MCJob")
public class MeasurementCollectionJob
extends MeasurementJob
implements PatchMeasurementCollectionJob200Response {
    @JsonProperty(value="outputFormat")
    private String outputFormat;
    @JsonProperty(value="reportingPeriod")
    private ReportingPeriod reportingPeriod;
    @Embedded
    @JsonProperty(value="jobCollectionFilter")
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="jcf_type")), @AttributeOverride(name="baseType", column=@Column(name="jcf_base_type")), @AttributeOverride(name="schemaLocation", column=@Column(name="jcf_schema_location"))})
    private DataFilterMap jobCollectionFilter;
    @Embedded
    @JsonProperty(value="searchTaskFilter")
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="stf_type")), @AttributeOverride(name="baseType", column=@Column(name="stf_base_type")), @AttributeOverride(name="schemaLocation", column=@Column(name="stf_schema_location"))})
    private DataFilterMap searchTaskFilter;
    @JsonProperty(value="jobOnDemand")
    private Boolean jobOnDemand = false;

    public MeasurementCollectionJob() {
    }

    public MeasurementCollectionJob(String atType) {
        super(atType);
    }

    public MeasurementCollectionJob outputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Schema(name="outputFormat", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public MeasurementCollectionJob reportingPeriod(ReportingPeriod reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
        return this;
    }

    @Valid
    @Schema(name="reportingPeriod", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ReportingPeriod getReportingPeriod() {
        return this.reportingPeriod;
    }

    public void setReportingPeriod(ReportingPeriod reportingPeriod) {
        this.reportingPeriod = reportingPeriod;
    }

    public MeasurementCollectionJob jobCollectionFilter(DataFilterMap jobCollectionFilter) {
        this.jobCollectionFilter = jobCollectionFilter;
        return this;
    }

    @Valid
    @Schema(name="jobCollectionFilter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public DataFilterMap getJobCollectionFilter() {
        return this.jobCollectionFilter;
    }

    public void setJobCollectionFilter(DataFilterMap jobCollectionFilter) {
        this.jobCollectionFilter = jobCollectionFilter;
    }

    public MeasurementCollectionJob searchTaskFilter(DataFilterMap searchTaskFilter) {
        this.searchTaskFilter = searchTaskFilter;
        return this;
    }

    @Valid
    @Schema(name="searchTaskFilter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public DataFilterMap getSearchTaskFilter() {
        return this.searchTaskFilter;
    }

    public void setSearchTaskFilter(DataFilterMap searchTaskFilter) {
        this.searchTaskFilter = searchTaskFilter;
    }

    public MeasurementCollectionJob jobOnDemand(Boolean jobOnDemand) {
        this.jobOnDemand = jobOnDemand;
        return this;
    }

    @Schema(name="jobOnDemand", description="True if the job is a single job to be executed immediately in which case the reportingPeriod and scheduleDefinition would not be applicable, false otherwise", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getJobOnDemand() {
        return this.jobOnDemand;
    }

    public void setJobOnDemand(Boolean jobOnDemand) {
        this.jobOnDemand = jobOnDemand;
    }

    @Override
    public MeasurementCollectionJob consumingApplicationId(String consumingApplicationId) {
        super.consumingApplicationId(consumingApplicationId);
        return this;
    }

    @Override
    public MeasurementCollectionJob producingApplicationId(String producingApplicationId) {
        super.producingApplicationId(producingApplicationId);
        return this;
    }

    @Override
    public MeasurementCollectionJob granularity(Granularity granularity) {
        super.granularity(granularity);
        return this;
    }

    @Override
    public MeasurementCollectionJob performanceIndicatorGroupSpecification(List<PerformanceIndicatorGroupSpecification> performanceIndicatorGroupSpecification) {
        super.performanceIndicatorGroupSpecification(performanceIndicatorGroupSpecification);
        return this;
    }

    @Override
    public MeasurementCollectionJob addPerformanceIndicatorGroupSpecificationItem(PerformanceIndicatorGroupSpecification performanceIndicatorGroupSpecificationItem) {
        super.addPerformanceIndicatorGroupSpecificationItem(performanceIndicatorGroupSpecificationItem);
        return this;
    }

    @Override
    public MeasurementCollectionJob performanceIndicatorSpecification(List<@Valid PerformanceIndicatorSpecificationRefOrValue> performanceIndicatorSpecification) {
        super.performanceIndicatorSpecification(performanceIndicatorSpecification);
        return this;
    }

    @Override
    public MeasurementCollectionJob addPerformanceIndicatorSpecificationItem(PerformanceIndicatorSpecificationRefOrValue performanceIndicatorSpecificationItem) {
        super.addPerformanceIndicatorSpecificationItem(performanceIndicatorSpecificationItem);
        return this;
    }

    @Override
    public MeasurementCollectionJob trackingRecord(List<TrackingRecord> trackingRecord) {
        super.trackingRecord(trackingRecord);
        return this;
    }

    @Override
    public MeasurementCollectionJob addTrackingRecordItem(TrackingRecord trackingRecordItem) {
        super.addTrackingRecordItem(trackingRecordItem);
        return this;
    }

    @Override
    public MeasurementCollectionJob monitoredInstancesCriteria(MonitoredInstancesCriteria monitoredInstancesCriteria) {
        super.monitoredInstancesCriteria(monitoredInstancesCriteria);
        return this;
    }

    @Override
    public MeasurementCollectionJob monitoredClassCriteria(MonitoredClassCriteria monitoredClassCriteria) {
        super.monitoredClassCriteria(monitoredClassCriteria);
        return this;
    }

    @Override
    public MeasurementCollectionJob adminState(AdministrativeState adminState) {
        super.adminState(adminState);
        return this;
    }

    @Override
    public MeasurementCollectionJob creationTime(OffsetDateTime creationTime) {
        super.creationTime(creationTime);
        return this;
    }

    @Override
    public MeasurementCollectionJob executionState(ExecutionStateType executionState) {
        super.executionState(executionState);
        return this;
    }

    @Override
    public MeasurementCollectionJob fileTransferData(List<FileTransferData> fileTransferData) {
        super.fileTransferData((List)fileTransferData);
        return this;
    }

    @Override
    public MeasurementCollectionJob addFileTransferDataItem(FileTransferData fileTransferDataItem) {
        super.addFileTransferDataItem(fileTransferDataItem);
        return this;
    }

    @Override
    public MeasurementCollectionJob dataAccessEndpoint(List<DataAccessEndpoint> dataAccessEndpoint) {
        super.dataAccessEndpoint((List)dataAccessEndpoint);
        return this;
    }

    @Override
    public MeasurementCollectionJob addDataAccessEndpointItem(DataAccessEndpoint dataAccessEndpointItem) {
        super.addDataAccessEndpointItem(dataAccessEndpointItem);
        return this;
    }

    @Override
    public MeasurementCollectionJob jobId(String jobId) {
        super.jobId(jobId);
        return this;
    }

    @Override
    public MeasurementCollectionJob jobPriority(Integer jobPriority) {
        super.jobPriority(jobPriority);
        return this;
    }

    @Override
    public MeasurementCollectionJob lastModifiedTime(OffsetDateTime lastModifiedTime) {
        super.lastModifiedTime(lastModifiedTime);
        return this;
    }

    @Override
    public MeasurementCollectionJob scheduleDefinition(List<ScheduleDefinition> scheduleDefinition) {
        super.scheduleDefinition((List)scheduleDefinition);
        return this;
    }

    @Override
    public MeasurementCollectionJob addScheduleDefinitionItem(ScheduleDefinition scheduleDefinitionItem) {
        super.addScheduleDefinitionItem(scheduleDefinitionItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementCollectionJob measurementCollectionJob = (MeasurementCollectionJob)o;
        return Objects.equals(this.outputFormat, measurementCollectionJob.outputFormat) && Objects.equals((Object)this.reportingPeriod, (Object)measurementCollectionJob.reportingPeriod) && Objects.equals(this.jobCollectionFilter, measurementCollectionJob.jobCollectionFilter) && Objects.equals(this.searchTaskFilter, measurementCollectionJob.searchTaskFilter) && Objects.equals(this.jobOnDemand, measurementCollectionJob.jobOnDemand) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.outputFormat, this.reportingPeriod, this.jobCollectionFilter, this.searchTaskFilter, this.jobOnDemand, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeasurementCollectionJob {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    outputFormat: ").append(this.toIndentedString(this.outputFormat)).append("\n");
        sb.append("    reportingPeriod: ").append(this.toIndentedString((Object)this.reportingPeriod)).append("\n");
        sb.append("    jobCollectionFilter: ").append(this.toIndentedString(this.jobCollectionFilter)).append("\n");
        sb.append("    searchTaskFilter: ").append(this.toIndentedString(this.searchTaskFilter)).append("\n");
        sb.append("    jobOnDemand: ").append(this.toIndentedString(this.jobOnDemand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

