/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointMVO;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferDataMVO;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobMVO;
import org.etsi.osl.tmf.pm628.model.MeasurementJobMVO;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionMVO;

@JsonIgnoreProperties(ignoreUnknown=true, value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ManagementJobMVO.class, name="ManagementJob"), @JsonSubTypes.Type(value=MeasurementCollectionJobMVO.class, name="MeasurementCollectionJob"), @JsonSubTypes.Type(value=MeasurementJobMVO.class, name="MeasurementJob")})
public class ManagementJobMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="fileTransferData")
    @Valid
    private List<FileTransferDataMVO> fileTransferData = null;
    @JsonProperty(value="dataAccessEndpoint")
    @Valid
    private List<DataAccessEndpointMVO> dataAccessEndpoint = null;
    @JsonProperty(value="scheduleDefinition")
    @Valid
    private List<ScheduleDefinitionMVO> scheduleDefinition = null;
    @JsonProperty(value="executionState")
    private ExecutionStateType executionState;

    public ManagementJobMVO() {
    }

    public ManagementJobMVO(String type) {
        this.type = type;
    }

    public ManagementJobMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ManagementJobMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ManagementJobMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ManagementJobMVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ManagementJobMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ManagementJobMVO fileTransferData(List<FileTransferDataMVO> fileTransferData) {
        this.fileTransferData = fileTransferData;
        return this;
    }

    public ManagementJobMVO addFileTransferDataItem(FileTransferDataMVO fileTransferDataItem) {
        if (this.fileTransferData == null) {
            this.fileTransferData = new ArrayList<FileTransferDataMVO>();
        }
        this.fileTransferData.add(fileTransferDataItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="fileTransferData", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<FileTransferDataMVO> getFileTransferData() {
        return this.fileTransferData;
    }

    public void setFileTransferData(List<FileTransferDataMVO> fileTransferData) {
        this.fileTransferData = fileTransferData;
    }

    public ManagementJobMVO dataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
        return this;
    }

    public ManagementJobMVO addDataAccessEndpointItem(DataAccessEndpointMVO dataAccessEndpointItem) {
        if (this.dataAccessEndpoint == null) {
            this.dataAccessEndpoint = new ArrayList<DataAccessEndpointMVO>();
        }
        this.dataAccessEndpoint.add(dataAccessEndpointItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="dataAccessEndpoint", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<DataAccessEndpointMVO> getDataAccessEndpoint() {
        return this.dataAccessEndpoint;
    }

    public void setDataAccessEndpoint(List<DataAccessEndpointMVO> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
    }

    public ManagementJobMVO scheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
        return this;
    }

    public ManagementJobMVO addScheduleDefinitionItem(ScheduleDefinitionMVO scheduleDefinitionItem) {
        if (this.scheduleDefinition == null) {
            this.scheduleDefinition = new ArrayList<ScheduleDefinitionMVO>();
        }
        this.scheduleDefinition.add(scheduleDefinitionItem);
        return this;
    }

    @Valid
    @Size(max=1)
    @Schema(name="scheduleDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(max=1) List<ScheduleDefinitionMVO> getScheduleDefinition() {
        return this.scheduleDefinition;
    }

    public void setScheduleDefinition(List<ScheduleDefinitionMVO> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementJobMVO managementJobMVO = (ManagementJobMVO)o;
        return Objects.equals(this.type, managementJobMVO.type) && Objects.equals(this.baseType, managementJobMVO.baseType) && Objects.equals(this.schemaLocation, managementJobMVO.schemaLocation) && Objects.equals(this.href, managementJobMVO.href) && Objects.equals(this.uuid, managementJobMVO.uuid) && Objects.equals((Object)this.executionState, (Object)managementJobMVO.executionState) && Objects.equals(this.fileTransferData, managementJobMVO.fileTransferData) && Objects.equals(this.dataAccessEndpoint, managementJobMVO.dataAccessEndpoint) && Objects.equals(this.scheduleDefinition, managementJobMVO.scheduleDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.fileTransferData, this.dataAccessEndpoint, this.scheduleDefinition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagementJobMVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    executionState: ").append(this.toIndentedString((Object)this.executionState)).append("\n");
        sb.append("    fileTransferData: ").append(this.toIndentedString(this.fileTransferData)).append("\n");
        sb.append("    dataAccessEndpoint: ").append(this.toIndentedString(this.dataAccessEndpoint)).append("\n");
        sb.append("    scheduleDefinition: ").append(this.toIndentedString(this.scheduleDefinition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonProperty(value="executionState")
    public void setExecutionState(ExecutionStateType executionState) {
        this.executionState = executionState;
    }

    public ExecutionStateType getExecutionState() {
        return this.executionState;
    }
}

