/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpointFVO;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferDataFVO;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJobFVO;
import org.etsi.osl.tmf.pm628.model.MeasurementJobFVO;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinitionFVO;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(ignoreUnknown=true, value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ManagementJobFVO.class, name="ManagementJob"), @JsonSubTypes.Type(value=MeasurementCollectionJobFVO.class, name="MeasurementCollectionJob"), @JsonSubTypes.Type(value=MeasurementJobFVO.class, name="MeasurementJob")})
public class ManagementJobFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="adminState")
    private AdministrativeState adminState;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime creationTime;
    @JsonProperty(value="executionState")
    private ExecutionStateType executionState;
    @JsonProperty(value="fileTransferData")
    @Valid
    private List<FileTransferDataFVO> fileTransferData = new ArrayList<FileTransferDataFVO>();
    @JsonProperty(value="dataAccessEndpoint")
    @Valid
    private List<DataAccessEndpointFVO> dataAccessEndpoint = new ArrayList<DataAccessEndpointFVO>();
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonProperty(value="jobPriority")
    private Integer jobPriority = 5;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="scheduleDefinition")
    @Valid
    private List<ScheduleDefinitionFVO> scheduleDefinition = new ArrayList<ScheduleDefinitionFVO>();

    public ManagementJobFVO() {
    }

    public ManagementJobFVO(String type) {
        this.type = type;
    }

    public ManagementJobFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ManagementJobFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ManagementJobFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ManagementJobFVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public ManagementJobFVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ManagementJobFVO adminState(AdministrativeState adminState) {
        this.adminState = adminState;
        return this;
    }

    @Valid
    @Schema(name="adminState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public AdministrativeState getAdminState() {
        return this.adminState;
    }

    public void setAdminState(AdministrativeState adminState) {
        this.adminState = adminState;
    }

    public ManagementJobFVO creationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Valid
    @Schema(name="creationTime", description="The measurement job creation time.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="creationTime")
    public String getCreationTimeStr() {
        return this.creationTime != null ? this.creationTime.toString() : null;
    }

    public void setCreationTime(String t) {
        if (t != null) {
            this.creationTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public ManagementJobFVO executionState(ExecutionStateType executionState) {
        this.executionState = executionState;
        return this;
    }

    @Valid
    @Schema(name="executionState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ExecutionStateType getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionStateType executionState) {
        this.executionState = executionState;
    }

    public ManagementJobFVO fileTransferData(List<FileTransferDataFVO> fileTransferData) {
        this.fileTransferData = fileTransferData;
        return this;
    }

    public ManagementJobFVO addFileTransferDataItem(FileTransferDataFVO fileTransferDataItem) {
        if (this.fileTransferData == null) {
            this.fileTransferData = new ArrayList<FileTransferDataFVO>();
        }
        this.fileTransferData.add(fileTransferDataItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="fileTransferData", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<FileTransferDataFVO> getFileTransferData() {
        return this.fileTransferData;
    }

    public void setFileTransferData(List<FileTransferDataFVO> fileTransferData) {
        this.fileTransferData = fileTransferData;
    }

    public ManagementJobFVO dataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
        return this;
    }

    public ManagementJobFVO addDataAccessEndpointItem(DataAccessEndpointFVO dataAccessEndpointItem) {
        if (this.dataAccessEndpoint == null) {
            this.dataAccessEndpoint = new ArrayList<DataAccessEndpointFVO>();
        }
        this.dataAccessEndpoint.add(dataAccessEndpointItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="dataAccessEndpoint", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<DataAccessEndpointFVO> getDataAccessEndpoint() {
        return this.dataAccessEndpoint;
    }

    public void setDataAccessEndpoint(List<DataAccessEndpointFVO> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
    }

    public ManagementJobFVO jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Schema(name="jobId", description="The ID of the management job.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ManagementJobFVO jobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    @Schema(name="jobPriority", description="The priority of the management job. The way the management application will use the JobPriority to schedule job execution is application specific and outside the scope. Integer, limited to a range of 1 to 10.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Min(value=1L) @Max(value=10L) Integer getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
    }

    public ManagementJobFVO lastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @Valid
    @Schema(name="lastModifiedTime", description="The last time that a measurement job was modified.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lastModifiedTime")
    public String getLastModifiedTimeStr() {
        return this.lastModifiedTime != null ? this.lastModifiedTime.toString() : null;
    }

    public void setLastModifiedTime(String t) {
        if (t != null) {
            this.lastModifiedTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public ManagementJobFVO scheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
        return this;
    }

    public ManagementJobFVO addScheduleDefinitionItem(ScheduleDefinitionFVO scheduleDefinitionItem) {
        if (this.scheduleDefinition == null) {
            this.scheduleDefinition = new ArrayList<ScheduleDefinitionFVO>();
        }
        this.scheduleDefinition.add(scheduleDefinitionItem);
        return this;
    }

    @Valid
    @Size(max=1)
    @Schema(name="scheduleDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(max=1) List<ScheduleDefinitionFVO> getScheduleDefinition() {
        return this.scheduleDefinition;
    }

    public void setScheduleDefinition(List<ScheduleDefinitionFVO> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementJobFVO managementJobFVO = (ManagementJobFVO)o;
        return Objects.equals(this.type, managementJobFVO.type) && Objects.equals(this.baseType, managementJobFVO.baseType) && Objects.equals(this.schemaLocation, managementJobFVO.schemaLocation) && Objects.equals(this.href, managementJobFVO.href) && Objects.equals(this.uuid, managementJobFVO.uuid) && Objects.equals((Object)this.adminState, (Object)managementJobFVO.adminState) && Objects.equals(this.creationTime, managementJobFVO.creationTime) && Objects.equals((Object)this.executionState, (Object)managementJobFVO.executionState) && Objects.equals(this.fileTransferData, managementJobFVO.fileTransferData) && Objects.equals(this.dataAccessEndpoint, managementJobFVO.dataAccessEndpoint) && Objects.equals(this.jobId, managementJobFVO.jobId) && Objects.equals(this.jobPriority, managementJobFVO.jobPriority) && Objects.equals(this.lastModifiedTime, managementJobFVO.lastModifiedTime) && Objects.equals(this.scheduleDefinition, managementJobFVO.scheduleDefinition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.adminState, this.creationTime, this.executionState, this.fileTransferData, this.dataAccessEndpoint, this.jobId, this.jobPriority, this.lastModifiedTime, this.scheduleDefinition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagementJobFVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    adminState: ").append(this.toIndentedString((Object)this.adminState)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    executionState: ").append(this.toIndentedString((Object)this.executionState)).append("\n");
        sb.append("    fileTransferData: ").append(this.toIndentedString(this.fileTransferData)).append("\n");
        sb.append("    dataAccessEndpoint: ").append(this.toIndentedString(this.dataAccessEndpoint)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobPriority: ").append(this.toIndentedString(this.jobPriority)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("    scheduleDefinition: ").append(this.toIndentedString(this.scheduleDefinition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

