/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.DataAccessEndpoint;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.FileTransferData;
import org.etsi.osl.tmf.pm628.model.MeasurementCollectionJob;
import org.etsi.osl.tmf.pm628.model.MeasurementJob;
import org.etsi.osl.tmf.pm628.model.ScheduleDefinition;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(value={"@type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ManagementJob.class, name="ManagementJob"), @JsonSubTypes.Type(value=MeasurementCollectionJob.class, name="MeasurementCollectionJob"), @JsonSubTypes.Type(value=MeasurementJob.class, name="MeasurementJob")})
@Entity(name="PM628_ManJob")
public class ManagementJob
extends BaseRootEntity {
    @JsonProperty(value="adminState")
    private AdministrativeState adminState;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime creationTime;
    @JsonProperty(value="executionState")
    private ExecutionStateType executionState;
    @JsonProperty(value="fileTransferData")
    @Valid
    @ElementCollection(targetClass=FileTransferData.class)
    @CollectionTable(name="pm628_man_job_ftd", joinColumns={@JoinColumn(name="man_job_id")})
    private List<FileTransferData> fileTransferData = new ArrayList<FileTransferData>();
    @JsonProperty(value="dataAccessEndpoint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_man_job_dae", joinColumns={@JoinColumn(name="man_job_uuid")}, inverseJoinColumns={@JoinColumn(name="dae_uuid")})
    private List<DataAccessEndpoint> dataAccessEndpoint = new ArrayList<DataAccessEndpoint>();
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonProperty(value="jobPriority")
    private Integer jobPriority = 5;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="scheduleDefinition")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_man_job_shched_def", joinColumns={@JoinColumn(name="man_job_uuid")}, inverseJoinColumns={@JoinColumn(name="sched_def_uuid")})
    private List<ScheduleDefinition> scheduleDefinition = new ArrayList<ScheduleDefinition>();

    public ManagementJob() {
    }

    public ManagementJob(String type) {
        this.type = type;
    }

    public ManagementJob adminState(AdministrativeState adminState) {
        this.adminState = adminState;
        return this;
    }

    @Valid
    @Schema(name="adminState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public AdministrativeState getAdminState() {
        return this.adminState;
    }

    public void setAdminState(AdministrativeState adminState) {
        this.adminState = adminState;
    }

    public ManagementJob creationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Valid
    @Schema(name="creationTime", description="The measurement job creation time.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="creationTime")
    public String getCreationTimeStr() {
        return this.creationTime != null ? this.creationTime.toString() : null;
    }

    public void setCreationTime(String t) {
        if (t != null) {
            this.creationTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public ManagementJob executionState(ExecutionStateType executionState) {
        this.executionState = executionState;
        return this;
    }

    @Valid
    @Schema(name="executionState", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public ExecutionStateType getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionStateType executionState) {
        this.executionState = executionState;
    }

    public ManagementJob fileTransferData(List<FileTransferData> fileTransferData) {
        this.fileTransferData = fileTransferData;
        return this;
    }

    public ManagementJob addFileTransferDataItem(FileTransferData fileTransferDataItem) {
        if (this.fileTransferData == null) {
            this.fileTransferData = new ArrayList<FileTransferData>();
        }
        this.fileTransferData.add(fileTransferDataItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="fileTransferData", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<FileTransferData> getFileTransferData() {
        return this.fileTransferData;
    }

    public void setFileTransferData(List<FileTransferData> fileTransferData) {
        this.fileTransferData = fileTransferData;
    }

    public ManagementJob dataAccessEndpoint(List<DataAccessEndpoint> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
        return this;
    }

    public ManagementJob addDataAccessEndpointItem(DataAccessEndpoint dataAccessEndpointItem) {
        if (this.dataAccessEndpoint == null) {
            this.dataAccessEndpoint = new ArrayList<DataAccessEndpoint>();
        }
        this.dataAccessEndpoint.add(dataAccessEndpointItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="dataAccessEndpoint", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(min=0) List<DataAccessEndpoint> getDataAccessEndpoint() {
        return this.dataAccessEndpoint;
    }

    public void setDataAccessEndpoint(List<DataAccessEndpoint> dataAccessEndpoint) {
        this.dataAccessEndpoint = dataAccessEndpoint;
    }

    public ManagementJob jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Schema(name="jobId", description="The ID of the management job.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ManagementJob jobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
        return this;
    }

    @Min(value=1L)
    @Max(value=10L)
    @Schema(name="jobPriority", description="The priority of the management job. The way the management application will use the JobPriority to schedule job execution is application specific and outside the scope. Integer, limited to a range of 1 to 10.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Min(value=1L) @Max(value=10L) Integer getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
    }

    public ManagementJob lastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @Valid
    @Schema(name="lastModifiedTime", description="The last time that a measurement job was modified.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="lastModifiedTime")
    public String getLastModifiedTimeStr() {
        return this.lastModifiedTime != null ? this.lastModifiedTime.toString() : null;
    }

    public void setLastModifiedTime(String t) {
        if (t != null) {
            this.lastModifiedTime = OffsetDateTime.parse(t);
        }
    }

    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public ManagementJob scheduleDefinition(List<ScheduleDefinition> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
        return this;
    }

    public ManagementJob addScheduleDefinitionItem(ScheduleDefinition scheduleDefinitionItem) {
        if (this.scheduleDefinition == null) {
            this.scheduleDefinition = new ArrayList<ScheduleDefinition>();
        }
        this.scheduleDefinition.add(scheduleDefinitionItem);
        return this;
    }

    @Valid
    @Size(max=1)
    @Schema(name="scheduleDefinition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid @Size(max=1) List<ScheduleDefinition> getScheduleDefinition() {
        return this.scheduleDefinition;
    }

    public void setScheduleDefinition(List<ScheduleDefinition> scheduleDefinition) {
        this.scheduleDefinition = scheduleDefinition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementJob managementJob = (ManagementJob)o;
        return Objects.equals(this.type, managementJob.type) && Objects.equals(this.baseType, managementJob.baseType) && Objects.equals(this.schemaLocation, managementJob.schemaLocation) && Objects.equals(this.href, managementJob.href) && Objects.equals(this.uuid, managementJob.uuid) && Objects.equals((Object)this.adminState, (Object)managementJob.adminState) && Objects.equals(this.creationTime, managementJob.creationTime) && Objects.equals((Object)this.executionState, (Object)managementJob.executionState) && Objects.equals(this.fileTransferData, managementJob.fileTransferData) && Objects.equals(this.dataAccessEndpoint, managementJob.dataAccessEndpoint) && Objects.equals(this.jobId, managementJob.jobId) && Objects.equals(this.jobPriority, managementJob.jobPriority) && Objects.equals(this.lastModifiedTime, managementJob.lastModifiedTime) && Objects.equals(this.scheduleDefinition, managementJob.scheduleDefinition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.uuid, this.adminState, this.creationTime, this.executionState, this.fileTransferData, this.dataAccessEndpoint, this.jobId, this.jobPriority, this.lastModifiedTime, this.scheduleDefinition});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagementJob {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    adminState: ").append(this.toIndentedString((Object)this.adminState)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    executionState: ").append(this.toIndentedString((Object)this.executionState)).append("\n");
        sb.append("    fileTransferData: ").append(this.toIndentedString(this.fileTransferData)).append("\n");
        sb.append("    dataAccessEndpoint: ").append(this.toIndentedString(this.dataAccessEndpoint)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobPriority: ").append(this.toIndentedString(this.jobPriority)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("    scheduleDefinition: ").append(this.toIndentedString(this.scheduleDefinition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

