/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@Schema(name="JsonPatch", description="A JSONPatch document as defined by RFC 6902")
public class JsonPatch {
    private OpEnum op;
    private String path;
    private JsonNullable<Object> value = JsonNullable.undefined();
    private String from;

    public JsonPatch() {
    }

    public JsonPatch(OpEnum op, String path) {
        this.op = op;
        this.path = path;
    }

    public JsonPatch op(OpEnum op) {
        this.op = op;
        return this;
    }

    @NotNull
    @Schema(name="op", description="The operation to be performed", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="op")
    public OpEnum getOp() {
        return this.op;
    }

    public void setOp(OpEnum op) {
        this.op = op;
    }

    public JsonPatch path(String path) {
        this.path = path;
        return this;
    }

    @NotNull
    @Schema(name="path", description="A JSON-Pointer", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public JsonPatch value(Object value) {
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    @Schema(name="value", description="The value to be used within the operations.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value")
    public JsonNullable<Object> getValue() {
        return this.value;
    }

    public void setValue(JsonNullable<Object> value) {
        this.value = value;
    }

    public JsonPatch from(String from) {
        this.from = from;
        return this;
    }

    @Schema(name="from", description="A string containing a JSON Pointer value.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPatch jsonPatch = (JsonPatch)o;
        return Objects.equals((Object)this.op, (Object)jsonPatch.op) && Objects.equals(this.path, jsonPatch.path) && JsonPatch.equalsNullable(this.value, jsonPatch.value) && Objects.equals(this.from, jsonPatch.from);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.path, JsonPatch.hashCodeNullable(this.value), this.from});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonPatch {\n");
        sb.append("    op: ").append(this.toIndentedString((Object)this.op)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OpEnum {
        ADD("add"),
        REMOVE("remove"),
        REPLACE("replace"),
        MOVE("move"),
        COPY("copy"),
        TEST("test");

        private String value;

        private OpEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OpEnum fromValue(String value) {
            for (OpEnum b : OpEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

