/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="IntentRef_MVO", description="Intent reference, for when Intent is used by other entities")
public class IntentRefMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="@referredType")
    private String referredType;

    public IntentRefMVO() {
    }

    public IntentRefMVO(String type) {
        this.type = type;
    }

    public IntentRefMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IntentRefMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public IntentRefMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public IntentRefMVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public IntentRefMVO id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="The identifier of the referred entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IntentRefMVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the referred entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntentRefMVO referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentRefMVO intentRefMVO = (IntentRefMVO)o;
        return Objects.equals(this.type, intentRefMVO.type) && Objects.equals(this.baseType, intentRefMVO.baseType) && Objects.equals(this.schemaLocation, intentRefMVO.schemaLocation) && Objects.equals(this.href, intentRefMVO.href) && Objects.equals(this.id, intentRefMVO.id) && Objects.equals(this.name, intentRefMVO.name) && Objects.equals(this.referredType, intentRefMVO.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.id, this.name, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntentRefMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

