/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="IntentRef", description="Intent reference, for when Intent is used by other entities")
@Embeddable
public class IntentRef {
    @JsonProperty(value="@type")
    @Column(name="ir_type")
    protected String type;
    @JsonProperty(value="@baseType")
    @Column(name="ir_base_type")
    protected String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="ir_schema_location")
    protected String schemaLocation;
    @JsonProperty(value="href")
    @Column(name="ir_href")
    protected String href;
    @JsonProperty(value="id")
    @Column(name="ir_id")
    protected String id;
    @JsonProperty(value="name")
    @Column(name="ir_name")
    protected String name;
    @JsonProperty(value="@referredType")
    @Column(name="ir_referred_type")
    private String referredType;

    public IntentRef() {
    }

    public IntentRef(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public IntentRef type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IntentRef baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public IntentRef schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public IntentRef href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="The URI of the referred entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public IntentRef id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="The identifier of the referred entity.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IntentRef name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the referred entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntentRef referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentRef intentRef = (IntentRef)o;
        return Objects.equals(this.type, intentRef.type) && Objects.equals(this.baseType, intentRef.baseType) && Objects.equals(this.schemaLocation, intentRef.schemaLocation) && Objects.equals(this.href, intentRef.href) && Objects.equals(this.id, intentRef.id) && Objects.equals(this.name, intentRef.name) && Objects.equals(this.referredType, intentRef.referredType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.id, this.name, this.referredType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntentRef {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

