/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="Hub", description="Sets the communication endpoint address the service instance must use to deliver notification information")
public class Hub {
    private String atType;
    private String atBaseType;
    private String atSchemaLocation;
    private String href;
    private String id;
    private String callback;
    private String query;

    public Hub() {
    }

    public Hub(String atType, String callback) {
        this.atType = atType;
        this.callback = callback;
    }

    public Hub atType(String atType) {
        this.atType = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public Hub atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public Hub atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public Hub href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="href")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Hub id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="Id of the listener", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Hub callback(String callback) {
        this.callback = callback;
        return this;
    }

    @NotNull
    @Schema(name="callback", description="The callback being registered.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="callback")
    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public Hub query(String query) {
        this.query = query;
        return this;
    }

    @Schema(name="query", description="additional data to be passed", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hub hub = (Hub)o;
        return Objects.equals(this.atType, hub.atType) && Objects.equals(this.atBaseType, hub.atBaseType) && Objects.equals(this.atSchemaLocation, hub.atSchemaLocation) && Objects.equals(this.href, hub.href) && Objects.equals(this.id, hub.id) && Objects.equals(this.callback, hub.callback) && Objects.equals(this.query, hub.query);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation, this.href, this.id, this.callback, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hub {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    callback: ").append(this.toIndentedString(this.callback)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

