/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CompressionType;
import org.etsi.osl.tmf.pm628.model.Duration;
import org.etsi.osl.tmf.pm628.model.PackingType;
import org.etsi.osl.tmf.pm628.model.ProtocolTransferData;

public class FileTransferDataMVO
extends ProtocolTransferData {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="fileLocation")
    private URI fileLocation;
    @JsonProperty(value="fileFormat")
    private String fileFormat;
    @JsonProperty(value="compressionType")
    private CompressionType compressionType;
    @JsonProperty(value="retentionPeriod")
    private Duration retentionPeriod;
    @JsonProperty(value="packingType")
    private PackingType packingType;

    public FileTransferDataMVO() {
    }

    public FileTransferDataMVO(String type) {
        this.type = type;
    }

    public FileTransferDataMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FileTransferDataMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FileTransferDataMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FileTransferDataMVO fileLocation(URI fileLocation) {
        this.fileLocation = fileLocation;
        return this;
    }

    @Valid
    @Schema(name="fileLocation", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public URI getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(URI fileLocation) {
        this.fileLocation = fileLocation;
    }

    public FileTransferDataMVO fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Schema(name="fileFormat", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public FileTransferDataMVO compressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    @Valid
    @Schema(name="compressionType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public FileTransferDataMVO retentionPeriod(Duration retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    @Valid
    @Schema(name="retentionPeriod", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Duration retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public FileTransferDataMVO packingType(PackingType packingType) {
        this.packingType = packingType;
        return this;
    }

    @Valid
    @Schema(name="packingType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public PackingType getPackingType() {
        return this.packingType;
    }

    public void setPackingType(PackingType packingType) {
        this.packingType = packingType;
    }

    @Override
    public FileTransferDataMVO transportProtocol(String transportProtocol) {
        super.transportProtocol(transportProtocol);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTransferDataMVO fileTransferDataMVO = (FileTransferDataMVO)o;
        return Objects.equals(this.type, fileTransferDataMVO.type) && Objects.equals(this.baseType, fileTransferDataMVO.baseType) && Objects.equals(this.schemaLocation, fileTransferDataMVO.schemaLocation) && Objects.equals(this.fileLocation, fileTransferDataMVO.fileLocation) && Objects.equals(this.fileFormat, fileTransferDataMVO.fileFormat) && Objects.equals(this.compressionType, fileTransferDataMVO.compressionType) && Objects.equals(this.retentionPeriod, fileTransferDataMVO.retentionPeriod) && Objects.equals(this.packingType, fileTransferDataMVO.packingType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.fileLocation, this.fileFormat, this.compressionType, this.retentionPeriod, this.packingType, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileTransferDataMVO {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    fileLocation: ").append(this.toIndentedString(this.fileLocation)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    compressionType: ").append(this.toIndentedString(this.compressionType)).append("\n");
        sb.append("    retentionPeriod: ").append(this.toIndentedString(this.retentionPeriod)).append("\n");
        sb.append("    packingType: ").append(this.toIndentedString(this.packingType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

