/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;

public class FeatureRelationshipFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="@referredType")
    private String referredType;
    @JsonProperty(value="relationshipType")
    private RelationshipTypeEnum relationshipType;
    @JsonProperty(value="validFor")
    private TimePeriod validFor;

    public FeatureRelationshipFVO() {
    }

    public FeatureRelationshipFVO(String type, String id, RelationshipTypeEnum relationshipType) {
        this.type = type;
        this.id = id;
        this.relationshipType = relationshipType;
    }

    public FeatureRelationshipFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FeatureRelationshipFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FeatureRelationshipFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FeatureRelationshipFVO href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public FeatureRelationshipFVO id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeatureRelationshipFVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="This is the name of the target feature.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeatureRelationshipFVO referredType(String referredType) {
        this.referredType = referredType;
        return this;
    }

    @Schema(name="@referredType", description="The actual type of the target instance when needed for disambiguation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getReferredType() {
        return this.referredType;
    }

    public void setReferredType(String referredType) {
        this.referredType = referredType;
    }

    public FeatureRelationshipFVO relationshipType(RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @NotNull
    @Schema(name="relationshipType", description="This is the type of the feature relationship.", requiredMode=Schema.RequiredMode.REQUIRED)
    public RelationshipTypeEnum getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
    }

    public FeatureRelationshipFVO validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Valid
    @Schema(name="validFor", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureRelationshipFVO featureRelationshipFVO = (FeatureRelationshipFVO)o;
        return Objects.equals(this.type, featureRelationshipFVO.type) && Objects.equals(this.baseType, featureRelationshipFVO.baseType) && Objects.equals(this.schemaLocation, featureRelationshipFVO.schemaLocation) && Objects.equals(this.href, featureRelationshipFVO.href) && Objects.equals(this.id, featureRelationshipFVO.id) && Objects.equals(this.name, featureRelationshipFVO.name) && Objects.equals(this.referredType, featureRelationshipFVO.referredType) && Objects.equals((Object)this.relationshipType, (Object)featureRelationshipFVO.relationshipType) && Objects.equals(this.validFor, featureRelationshipFVO.validFor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.baseType, this.schemaLocation, this.href, this.id, this.name, this.referredType, this.relationshipType, this.validFor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureRelationshipFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referredType: ").append(this.toIndentedString(this.referredType)).append("\n");
        sb.append("    relationshipType: ").append(this.toIndentedString((Object)this.relationshipType)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RelationshipTypeEnum {
        EXCLUDED("excluded"),
        INCLUDES("includes"),
        MAY_INCLUDE("may include"),
        REQUIRES("requires");

        private String value;

        private RelationshipTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelationshipTypeEnum fromValue(String value) {
            for (RelationshipTypeEnum b : RelationshipTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

