/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicMVO;
import org.etsi.osl.tmf.pm628.model.FeatureRelationshipMVO;
import org.etsi.osl.tmf.pm628.model.PolicyRefMVO;

public class FeatureMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="isBundle")
    private Boolean isBundle;
    @JsonProperty(value="featureRelationship")
    @Valid
    private List<FeatureRelationshipMVO> featureRelationship = new ArrayList<FeatureRelationshipMVO>();
    @JsonProperty(value="featureCharacteristic")
    @Valid
    private List<CharacteristicMVO> featureCharacteristic = new ArrayList<CharacteristicMVO>();
    @JsonProperty(value="policyConstraint")
    @Valid
    private List<PolicyRefMVO> policyConstraint = new ArrayList<PolicyRefMVO>();
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;

    public FeatureMVO() {
    }

    public FeatureMVO(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public FeatureMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FeatureMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FeatureMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FeatureMVO isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(name="isBundle", description="True if this is a feature group. Default is false.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public FeatureMVO featureRelationship(List<FeatureRelationshipMVO> featureRelationship) {
        this.featureRelationship = featureRelationship;
        return this;
    }

    public FeatureMVO addFeatureRelationshipItem(FeatureRelationshipMVO featureRelationshipItem) {
        if (this.featureRelationship == null) {
            this.featureRelationship = new ArrayList<FeatureRelationshipMVO>();
        }
        this.featureRelationship.add(featureRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="featureRelationship", description="Collection of feature relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<FeatureRelationshipMVO> getFeatureRelationship() {
        return this.featureRelationship;
    }

    public void setFeatureRelationship(List<FeatureRelationshipMVO> featureRelationship) {
        this.featureRelationship = featureRelationship;
    }

    public FeatureMVO featureCharacteristic(List<CharacteristicMVO> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
        return this;
    }

    public FeatureMVO addFeatureCharacteristicItem(CharacteristicMVO featureCharacteristicItem) {
        if (this.featureCharacteristic == null) {
            this.featureCharacteristic = new ArrayList<CharacteristicMVO>();
        }
        this.featureCharacteristic.add(featureCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="featureCharacteristic", description="This is a list of Characteristics for a particular feature.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicMVO> getFeatureCharacteristic() {
        return this.featureCharacteristic;
    }

    public void setFeatureCharacteristic(List<CharacteristicMVO> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
    }

    public FeatureMVO policyConstraint(List<PolicyRefMVO> policyConstraint) {
        this.policyConstraint = policyConstraint;
        return this;
    }

    public FeatureMVO addPolicyConstraintItem(PolicyRefMVO policyConstraintItem) {
        if (this.policyConstraint == null) {
            this.policyConstraint = new ArrayList<PolicyRefMVO>();
        }
        this.policyConstraint.add(policyConstraintItem);
        return this;
    }

    @Valid
    @Schema(name="policyConstraint", description="Reference to manage a list of feature specification policy constraints", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<PolicyRefMVO> getPolicyConstraint() {
        return this.policyConstraint;
    }

    public void setPolicyConstraint(List<PolicyRefMVO> policyConstraint) {
        this.policyConstraint = policyConstraint;
    }

    public FeatureMVO isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(name="isEnabled", description="True if this feature is enabled. Default is true.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public FeatureMVO uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(name="uuid", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public FeatureMVO name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="This is the name for the feature.", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureMVO featureMVO = (FeatureMVO)o;
        return Objects.equals(this.type, featureMVO.type) && Objects.equals(this.baseType, featureMVO.baseType) && Objects.equals(this.schemaLocation, featureMVO.schemaLocation) && Objects.equals(this.isBundle, featureMVO.isBundle) && Objects.equals(this.featureRelationship, featureMVO.featureRelationship) && Objects.equals(this.featureCharacteristic, featureMVO.featureCharacteristic) && Objects.equals(this.policyConstraint, featureMVO.policyConstraint) && Objects.equals(this.isEnabled, featureMVO.isEnabled) && Objects.equals(this.uuid, featureMVO.uuid) && Objects.equals(this.name, featureMVO.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.isBundle, this.featureRelationship, this.featureCharacteristic, this.policyConstraint, this.isEnabled, this.uuid, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    featureRelationship: ").append(this.toIndentedString(this.featureRelationship)).append("\n");
        sb.append("    featureCharacteristic: ").append(this.toIndentedString(this.featureCharacteristic)).append("\n");
        sb.append("    policyConstraint: ").append(this.toIndentedString(this.policyConstraint)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

