/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.CharacteristicFVO;
import org.etsi.osl.tmf.pm628.model.FeatureRelationshipFVO;
import org.etsi.osl.tmf.pm628.model.PolicyRefFVO;

public class FeatureFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="isBundle")
    private Boolean isBundle;
    @JsonProperty(value="featureRelationship")
    @Valid
    private List<FeatureRelationshipFVO> featureRelationship = new ArrayList<FeatureRelationshipFVO>();
    @JsonProperty(value="featureCharacteristic")
    @Valid
    private List<CharacteristicFVO> featureCharacteristic = new ArrayList<CharacteristicFVO>();
    @JsonProperty(value="policyConstraint")
    @Valid
    private List<PolicyRefFVO> policyConstraint = new ArrayList<PolicyRefFVO>();
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled;
    @JsonProperty(value="name")
    private String name;

    public FeatureFVO() {
    }

    public FeatureFVO(String type) {
        this.type = type;
    }

    public FeatureFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FeatureFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public FeatureFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public FeatureFVO isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(name="isBundle", description="True if this is a feature group. Default is false.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public FeatureFVO featureRelationship(List<FeatureRelationshipFVO> featureRelationship) {
        this.featureRelationship = featureRelationship;
        return this;
    }

    public FeatureFVO addFeatureRelationshipItem(FeatureRelationshipFVO featureRelationshipItem) {
        if (this.featureRelationship == null) {
            this.featureRelationship = new ArrayList<FeatureRelationshipFVO>();
        }
        this.featureRelationship.add(featureRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="featureRelationship", description="Collection of feature relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<FeatureRelationshipFVO> getFeatureRelationship() {
        return this.featureRelationship;
    }

    public void setFeatureRelationship(List<FeatureRelationshipFVO> featureRelationship) {
        this.featureRelationship = featureRelationship;
    }

    public FeatureFVO featureCharacteristic(List<CharacteristicFVO> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
        return this;
    }

    public FeatureFVO addFeatureCharacteristicItem(CharacteristicFVO featureCharacteristicItem) {
        if (this.featureCharacteristic == null) {
            this.featureCharacteristic = new ArrayList<CharacteristicFVO>();
        }
        this.featureCharacteristic.add(featureCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="featureCharacteristic", description="This is a list of Characteristics for a particular feature.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<CharacteristicFVO> getFeatureCharacteristic() {
        return this.featureCharacteristic;
    }

    public void setFeatureCharacteristic(List<CharacteristicFVO> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
    }

    public FeatureFVO policyConstraint(List<PolicyRefFVO> policyConstraint) {
        this.policyConstraint = policyConstraint;
        return this;
    }

    public FeatureFVO addPolicyConstraintItem(PolicyRefFVO policyConstraintItem) {
        if (this.policyConstraint == null) {
            this.policyConstraint = new ArrayList<PolicyRefFVO>();
        }
        this.policyConstraint.add(policyConstraintItem);
        return this;
    }

    @Valid
    @Schema(name="policyConstraint", description="Reference to manage a list of feature specification policy constraints", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<PolicyRefFVO> getPolicyConstraint() {
        return this.policyConstraint;
    }

    public void setPolicyConstraint(List<PolicyRefFVO> policyConstraint) {
        this.policyConstraint = policyConstraint;
    }

    public FeatureFVO isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(name="isEnabled", description="True if this feature is enabled. Default is true.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public FeatureFVO name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="This is the name for the feature.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFVO featureFVO = (FeatureFVO)o;
        return Objects.equals(this.type, featureFVO.type) && Objects.equals(this.baseType, featureFVO.baseType) && Objects.equals(this.schemaLocation, featureFVO.schemaLocation) && Objects.equals(this.isBundle, featureFVO.isBundle) && Objects.equals(this.featureRelationship, featureFVO.featureRelationship) && Objects.equals(this.featureCharacteristic, featureFVO.featureCharacteristic) && Objects.equals(this.policyConstraint, featureFVO.policyConstraint) && Objects.equals(this.isEnabled, featureFVO.isEnabled) && Objects.equals(this.name, featureFVO.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.isBundle, this.featureRelationship, this.featureCharacteristic, this.policyConstraint, this.isEnabled, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    featureRelationship: ").append(this.toIndentedString(this.featureRelationship)).append("\n");
        sb.append("    featureCharacteristic: ").append(this.toIndentedString(this.featureCharacteristic)).append("\n");
        sb.append("    policyConstraint: ").append(this.toIndentedString(this.policyConstraint)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

