/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.PolicyRef;
import org.etsi.osl.tmf.ri639.model.FeatureRelationship;

@Entity(name="PM628_Feature")
public class Feature
extends BaseRootNamedEntity {
    @JsonProperty(value="isBundle")
    private Boolean isBundle;
    @JsonProperty(value="featureRelationship")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_feature_feat_rel", joinColumns={@JoinColumn(name="feat_uuid")}, inverseJoinColumns={@JoinColumn(name="feat_rel_uuid")})
    private List<FeatureRelationship> featureRelationship = new ArrayList<FeatureRelationship>();
    @JsonProperty(value="featureCharacteristic")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_feature_feat_char", joinColumns={@JoinColumn(name="feat_uuid")}, inverseJoinColumns={@JoinColumn(name="feat_char_uuid")})
    private List<Characteristic> featureCharacteristic = new ArrayList<Characteristic>();
    @JsonProperty(value="policyConstraint")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="pm628_feature_pol_const", joinColumns={@JoinColumn(name="feat_uuid")}, inverseJoinColumns={@JoinColumn(name="pol_const_uuid")})
    private List<PolicyRef> policyConstraint = new ArrayList<PolicyRef>();
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled;

    public Feature() {
    }

    public Feature(String type) {
        this.type = type;
    }

    public Feature isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(name="isBundle", description="True if this is a feature group. Default is false.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public Feature featureRelationship(List<FeatureRelationship> featureRelationship) {
        this.featureRelationship = featureRelationship;
        return this;
    }

    public Feature addFeatureRelationshipItem(FeatureRelationship featureRelationshipItem) {
        if (this.featureRelationship == null) {
            this.featureRelationship = new ArrayList<FeatureRelationship>();
        }
        this.featureRelationship.add(featureRelationshipItem);
        return this;
    }

    @Valid
    @Schema(name="featureRelationship", description="Collection of feature relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<FeatureRelationship> getFeatureRelationship() {
        return this.featureRelationship;
    }

    public void setFeatureRelationship(List<FeatureRelationship> featureRelationship) {
        this.featureRelationship = featureRelationship;
    }

    public Feature featureCharacteristic(List<Characteristic> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
        return this;
    }

    public Feature addFeatureCharacteristicItem(Characteristic featureCharacteristicItem) {
        if (this.featureCharacteristic == null) {
            this.featureCharacteristic = new ArrayList<Characteristic>();
        }
        this.featureCharacteristic.add(featureCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="featureCharacteristic", description="This is a list of Characteristics for a particular feature.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Characteristic> getFeatureCharacteristic() {
        return this.featureCharacteristic;
    }

    public void setFeatureCharacteristic(List<Characteristic> featureCharacteristic) {
        this.featureCharacteristic = featureCharacteristic;
    }

    public Feature policyConstraint(List<PolicyRef> policyConstraint) {
        this.policyConstraint = policyConstraint;
        return this;
    }

    public Feature addPolicyConstraintItem(PolicyRef policyConstraintItem) {
        if (this.policyConstraint == null) {
            this.policyConstraint = new ArrayList<PolicyRef>();
        }
        this.policyConstraint.add(policyConstraintItem);
        return this;
    }

    @Valid
    @Schema(name="policyConstraint", description="Reference to manage a list of feature specification policy constraints", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<PolicyRef> getPolicyConstraint() {
        return this.policyConstraint;
    }

    public void setPolicyConstraint(List<PolicyRef> policyConstraint) {
        this.policyConstraint = policyConstraint;
    }

    public Feature isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(name="isEnabled", description="True if this feature is enabled. Default is true.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.type, feature.type) && Objects.equals(this.baseType, feature.baseType) && Objects.equals(this.schemaLocation, feature.schemaLocation) && Objects.equals(this.isBundle, feature.isBundle) && Objects.equals(this.featureRelationship, feature.featureRelationship) && Objects.equals(this.featureCharacteristic, feature.featureCharacteristic) && Objects.equals(this.policyConstraint, feature.policyConstraint) && Objects.equals(this.isEnabled, feature.isEnabled) && Objects.equals(this.uuid, feature.uuid) && Objects.equals(this.name, feature.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.isBundle, this.featureRelationship, this.featureCharacteristic, this.policyConstraint, this.isEnabled, this.uuid, this.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Feature {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    featureRelationship: ").append(this.toIndentedString(this.featureRelationship)).append("\n");
        sb.append("    featureCharacteristic: ").append(this.toIndentedString(this.featureCharacteristic)).append("\n");
        sb.append("    policyConstraint: ").append(this.toIndentedString(this.policyConstraint)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

