/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Embeddable
public class ExternalIdentifier {
    @JsonProperty(value="@type")
    @Column(name="ei_type")
    protected String type;
    @JsonProperty(value="@baseType")
    @Column(name="ei_base_type")
    protected String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="ei_schema_location")
    protected String schemaLocation;
    @JsonProperty(value="owner")
    @Column(name="ei_owner")
    private String owner;
    @JsonProperty(value="externalIdentifierType")
    @Column(name="ei_ext_idf_type")
    private String externalIdentifierType;
    @JsonProperty(value="id")
    @Column(name="ei_id")
    protected String id;

    public ExternalIdentifier() {
    }

    public ExternalIdentifier(String type) {
        this.type = type;
    }

    public ExternalIdentifier type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ExternalIdentifier baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ExternalIdentifier schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ExternalIdentifier owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(name="owner", example="MagentoCommerce", description="Name of the external system that owns the entity.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ExternalIdentifier externalIdentifierType(String externalIdentifierType) {
        this.externalIdentifierType = externalIdentifierType;
        return this;
    }

    @Schema(name="externalIdentifierType", example="ProductOrder", description="Type of the identification, typically would be the type of the entity within the external system", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getExternalIdentifierType() {
        return this.externalIdentifierType;
    }

    public void setExternalIdentifierType(String externalIdentifierType) {
        this.externalIdentifierType = externalIdentifierType;
    }

    public ExternalIdentifier id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="identification of the entity within the external system.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIdentifier externalIdentifier = (ExternalIdentifier)o;
        return Objects.equals(this.type, externalIdentifier.type) && Objects.equals(this.baseType, externalIdentifier.baseType) && Objects.equals(this.schemaLocation, externalIdentifier.schemaLocation) && Objects.equals(this.owner, externalIdentifier.owner) && Objects.equals(this.externalIdentifierType, externalIdentifier.externalIdentifierType) && Objects.equals(this.id, externalIdentifier.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.owner, this.externalIdentifierType, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalIdentifier {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    externalIdentifierType: ").append(this.toIndentedString(this.externalIdentifierType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

