/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.etsi.osl.tmf.pm628.model.Characteristic;
import org.etsi.osl.tmf.pm628.model.RelatedPartyRefOrPartyRoleRef;
import org.etsi.osl.tmf.ri639.model.EntityRef;
import org.springframework.format.annotation.DateTimeFormat;

public class Event {
    @JsonProperty(value="@type")
    protected String type;
    @JsonProperty(value="@baseType")
    protected String baseType;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation;
    @JsonProperty(value="href")
    protected String href;
    @JsonProperty(value="id")
    protected String id = UUID.randomUUID().toString();
    @JsonProperty(value="correlationId")
    protected String correlationId;
    @JsonProperty(value="domain")
    protected String domain;
    @JsonProperty(value="title")
    protected String title;
    @JsonProperty(value="description")
    protected String description;
    @JsonProperty(value="priority")
    protected String priority;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    protected OffsetDateTime timeOccurred;
    @JsonProperty(value="source")
    protected EntityRef source;
    @JsonProperty(value="reportingSystem")
    protected EntityRef reportingSystem;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedPartyRefOrPartyRoleRef> relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRef>();
    @JsonProperty(value="analyticCharacteristic")
    @Valid
    protected List<Characteristic> analyticCharacteristic = new ArrayList<Characteristic>();
    @JsonProperty(value="eventId")
    protected String eventId = UUID.randomUUID().toString();
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    protected OffsetDateTime eventTime = OffsetDateTime.now(ZoneOffset.UTC);
    @JsonProperty(value="eventType")
    protected String eventType;
    @JsonProperty(value="event")
    protected Object event;

    public Event() {
    }

    public Event(String type) {
        this.type = type;
    }

    public Event type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Event baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public Event schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Event href(String href) {
        this.href = href;
        return this;
    }

    @Schema(name="href", description="Hyperlink reference", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Event id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="unique identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Event correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Schema(name="correlationId", description="The correlation id for this event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public Event domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Schema(name="domain", description="The domain of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Event title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="The title of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Event description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="An explanation of the event.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Event priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", description="A priority.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Event timeOccurred(OffsetDateTime timeOccurred) {
        this.timeOccurred = timeOccurred;
        return this;
    }

    @Valid
    @Schema(name="timeOccurred", description="The time the event occurred.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="timeOccurred")
    public String getTimeOccurredString() {
        return this.timeOccurred != null ? this.timeOccurred.toString() : null;
    }

    public void setTimeOccurred(String timeOccurred) {
        if (timeOccurred != null) {
            this.timeOccurred = OffsetDateTime.parse(timeOccurred);
        }
    }

    public OffsetDateTime getTimeOccurred() {
        return this.timeOccurred;
    }

    public void setTimeOccurred(OffsetDateTime timeOccurred) {
        this.timeOccurred = timeOccurred;
    }

    public Event source(EntityRef source) {
        this.source = source;
        return this;
    }

    @Valid
    @Schema(name="source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public EntityRef getSource() {
        return this.source;
    }

    public void setSource(EntityRef source) {
        this.source = source;
    }

    public Event reportingSystem(EntityRef reportingSystem) {
        this.reportingSystem = reportingSystem;
        return this;
    }

    @Valid
    @Schema(name="reportingSystem", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public EntityRef getReportingSystem() {
        return this.reportingSystem;
    }

    public void setReportingSystem(EntityRef reportingSystem) {
        this.reportingSystem = reportingSystem;
    }

    public Event relatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public Event addRelatedPartyItem(RelatedPartyRefOrPartyRoleRef relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedPartyRefOrPartyRoleRef>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Valid
    @Schema(name="relatedParty", description="Collection of related parties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<RelatedPartyRefOrPartyRoleRef> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedPartyRefOrPartyRoleRef> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public Event analyticCharacteristic(List<Characteristic> analyticCharacteristic) {
        this.analyticCharacteristic = analyticCharacteristic;
        return this;
    }

    public Event addAnalyticCharacteristicItem(Characteristic analyticCharacteristicItem) {
        if (this.analyticCharacteristic == null) {
            this.analyticCharacteristic = new ArrayList<Characteristic>();
        }
        this.analyticCharacteristic.add(analyticCharacteristicItem);
        return this;
    }

    @Valid
    @Schema(name="analyticCharacteristic", description="Collection of analytic characteristics", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public List<Characteristic> getAnalyticCharacteristic() {
        return this.analyticCharacteristic;
    }

    public void setAnalyticCharacteristic(List<Characteristic> analyticCharacteristic) {
        this.analyticCharacteristic = analyticCharacteristic;
    }

    public Event eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Schema(name="eventId", description="The identifier of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Event eventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Valid
    @Schema(name="eventTime", description="Time of the event occurrence.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    @JsonProperty(value="eventTime")
    public String getEventTimeString() {
        return this.eventTime != null ? this.eventTime.toString() : null;
    }

    public void setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventTime(String eventTime) {
        if (eventTime != null) {
            this.eventTime = OffsetDateTime.parse(eventTime);
        }
    }

    public Event eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Schema(name="eventType", description="The type of the notification.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Event event(Object event) {
        this.event = event;
        return this;
    }

    @Schema(name="event", description="The event linked to the involved resource object", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.type, event.type) && Objects.equals(this.baseType, event.baseType) && Objects.equals(this.schemaLocation, event.schemaLocation) && Objects.equals(this.href, event.href) && Objects.equals(this.id, event.id) && Objects.equals(this.correlationId, event.correlationId) && Objects.equals(this.domain, event.domain) && Objects.equals(this.title, event.title) && Objects.equals(this.description, event.description) && Objects.equals(this.priority, event.priority) && Objects.equals(this.timeOccurred, event.timeOccurred) && Objects.equals(this.source, event.source) && Objects.equals(this.reportingSystem, event.reportingSystem) && Objects.equals(this.relatedParty, event.relatedParty) && Objects.equals(this.analyticCharacteristic, event.analyticCharacteristic) && Objects.equals(this.eventId, event.eventId) && Objects.equals(this.eventTime, event.eventTime) && Objects.equals(this.eventType, event.eventType) && Objects.equals(this.event, event.event);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.href, this.id, this.correlationId, this.domain, this.title, this.description, this.priority, this.timeOccurred, this.source, this.reportingSystem, this.relatedParty, this.analyticCharacteristic, this.eventId, this.eventTime, this.eventType, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    timeOccurred: ").append(this.toIndentedString(this.timeOccurred)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    reportingSystem: ").append(this.toIndentedString(this.reportingSystem)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    analyticCharacteristic: ").append(this.toIndentedString(this.analyticCharacteristic)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

