/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="Entity_MVO", description="Base entity schema for use in TMForum Open-APIs. Property.")
@JsonTypeName(value="Entity_MVO")
public class EntityMVO {
    private String atType;
    private String atBaseType;
    private String atSchemaLocation;

    public EntityMVO() {
    }

    public EntityMVO(String atType) {
        this.atType = atType;
    }

    public EntityMVO atType(String atType) {
        this.atType = atType;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="@type")
    public String getAtType() {
        return this.atType;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public EntityMVO atBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@baseType")
    public String getAtBaseType() {
        return this.atBaseType;
    }

    public void setAtBaseType(String atBaseType) {
        this.atBaseType = atBaseType;
    }

    public EntityMVO atSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="@schemaLocation")
    public String getAtSchemaLocation() {
        return this.atSchemaLocation;
    }

    public void setAtSchemaLocation(String atSchemaLocation) {
        this.atSchemaLocation = atSchemaLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMVO entityMVO = (EntityMVO)o;
        return Objects.equals(this.atType, entityMVO.atType) && Objects.equals(this.atBaseType, entityMVO.atBaseType) && Objects.equals(this.atSchemaLocation, entityMVO.atSchemaLocation);
    }

    public int hashCode() {
        return Objects.hash(this.atType, this.atBaseType, this.atSchemaLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityMVO {\n");
        sb.append("    atType: ").append(this.toIndentedString(this.atType)).append("\n");
        sb.append("    atBaseType: ").append(this.toIndentedString(this.atBaseType)).append("\n");
        sb.append("    atSchemaLocation: ").append(this.toIndentedString(this.atSchemaLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

