/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

public class DayOfWeekRecurrenceMVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime dates;

    public DayOfWeekRecurrenceMVO() {
    }

    public DayOfWeekRecurrenceMVO(String type) {
        this.type = type;
    }

    public DayOfWeekRecurrenceMVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DayOfWeekRecurrenceMVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public DayOfWeekRecurrenceMVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DayOfWeekRecurrenceMVO dates(OffsetDateTime dates) {
        this.dates = dates;
        return this;
    }

    @Valid
    @Schema(name="dates", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dates")
    public String getDatesString() {
        return this.dates != null ? this.dates.toString() : null;
    }

    public void setDates(String dates) {
        if (dates != null) {
            this.dates = OffsetDateTime.parse(dates);
        }
    }

    public OffsetDateTime getDates() {
        return this.dates;
    }

    public void setDates(OffsetDateTime dates) {
        this.dates = dates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayOfWeekRecurrenceMVO dayOfWeekRecurrenceMVO = (DayOfWeekRecurrenceMVO)o;
        return Objects.equals(this.type, dayOfWeekRecurrenceMVO.type) && Objects.equals(this.baseType, dayOfWeekRecurrenceMVO.baseType) && Objects.equals(this.schemaLocation, dayOfWeekRecurrenceMVO.schemaLocation) && Objects.equals(this.dates, dayOfWeekRecurrenceMVO.dates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.dates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DayOfWeekRecurrenceMVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    dates: ").append(this.toIndentedString(this.dates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

