/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@Embeddable
public class DayOfWeekRecurrence {
    @JsonProperty(value="@type")
    @Column(name="dowr_type")
    private String type;
    @JsonProperty(value="@baseType")
    @Column(name="dowr_base_type")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    @Column(name="dowr_schema_location")
    private String schemaLocation;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime dates;

    public DayOfWeekRecurrence() {
    }

    public DayOfWeekRecurrence(String type) {
        this.type = type;
    }

    public DayOfWeekRecurrence type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DayOfWeekRecurrence baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public DayOfWeekRecurrence schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DayOfWeekRecurrence dates(OffsetDateTime dates) {
        this.dates = dates;
        return this;
    }

    @Valid
    @Schema(name="dates", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public OffsetDateTime getDates() {
        return this.dates;
    }

    @JsonProperty(value="dates")
    public String getDatesString() {
        return this.dates != null ? this.dates.toString() : null;
    }

    public void setDates(String dates) {
        if (dates != null) {
            this.dates = OffsetDateTime.parse(dates);
        }
    }

    public void setDates(OffsetDateTime dates) {
        this.dates = dates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayOfWeekRecurrence dayOfWeekRecurrence = (DayOfWeekRecurrence)o;
        return Objects.equals(this.type, dayOfWeekRecurrence.type) && Objects.equals(this.baseType, dayOfWeekRecurrence.baseType) && Objects.equals(this.schemaLocation, dayOfWeekRecurrence.schemaLocation) && Objects.equals(this.dates, dayOfWeekRecurrence.dates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.dates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DayOfWeekRecurrence {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    dates: ").append(this.toIndentedString(this.dates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

