/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Embeddable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Embeddable
public class DataFilterTemplate {
    @JsonProperty(value="@type")
    protected String type;
    @JsonProperty(value="@baseType")
    protected String baseType;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation;
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="href")
    protected String href;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="description")
    protected String description;

    public DataFilterTemplate() {
    }

    public DataFilterTemplate(String type) {
        this.type = type;
    }

    public DataFilterTemplate type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataFilterTemplate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public DataFilterTemplate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DataFilterTemplate id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", example="6c088cf7f1bc", description="Unique identifier of this DataFilterTemplate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DataFilterTemplate href(String href) {
        this.href = href;
        return this;
    }

    @Valid
    @Schema(name="href", example="https://host/dataFilerTemplate/6c088cf7f1bc", description="Hyperlink reference to this DataFilterTemplate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public DataFilterTemplate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name given to this DataFilterTemplate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataFilterTemplate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description of this DataFilterTemplate", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFilterTemplate dataFilterTemplate = (DataFilterTemplate)o;
        return Objects.equals(this.type, dataFilterTemplate.type) && Objects.equals(this.baseType, dataFilterTemplate.baseType) && Objects.equals(this.schemaLocation, dataFilterTemplate.schemaLocation) && Objects.equals(this.id, dataFilterTemplate.id) && Objects.equals(this.href, dataFilterTemplate.href) && Objects.equals(this.name, dataFilterTemplate.name) && Objects.equals(this.description, dataFilterTemplate.description);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.id, this.href, this.name, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataFilterTemplate {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

