/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.pm628.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.pm628.model.DataFilterMapItemFVO;

public class DataFilterMapFVO {
    @JsonProperty(value="@type")
    private String type;
    @JsonProperty(value="@baseType")
    private String baseType;
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation;
    @JsonProperty(value="mappings")
    @Valid
    private @Valid List<@Valid DataFilterMapItemFVO> mappings = new ArrayList<DataFilterMapItemFVO>();

    public DataFilterMapFVO() {
    }

    public DataFilterMapFVO(String type) {
        this.type = type;
    }

    public DataFilterMapFVO type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="@type", description="When sub-classing, this defines the sub-class Extensible name", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataFilterMapFVO baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(name="@baseType", description="When sub-classing, this defines the super-class", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public DataFilterMapFVO schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(name="@schemaLocation", description="A URI to a JSON-Schema file that defines additional attributes and relationships", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public DataFilterMapFVO mappings(List<@Valid DataFilterMapItemFVO> mappings) {
        this.mappings = mappings;
        return this;
    }

    public DataFilterMapFVO addMappingsItem(DataFilterMapItemFVO mappingsItem) {
        if (this.mappings == null) {
            this.mappings = new ArrayList<DataFilterMapItemFVO>();
        }
        this.mappings.add(mappingsItem);
        return this;
    }

    @Valid
    @Schema(name="mappings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public @Valid List<@Valid DataFilterMapItemFVO> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<@Valid DataFilterMapItemFVO> mappings) {
        this.mappings = mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFilterMapFVO dataFilterMapFVO = (DataFilterMapFVO)o;
        return Objects.equals(this.type, dataFilterMapFVO.type) && Objects.equals(this.baseType, dataFilterMapFVO.baseType) && Objects.equals(this.schemaLocation, dataFilterMapFVO.schemaLocation) && Objects.equals(this.mappings, dataFilterMapFVO.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.baseType, this.schemaLocation, this.mappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataFilterMapFVO {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    mappings: ").append(this.toIndentedString(this.mappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

